/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.backend.wasm;

import com.alibaba.fastjson.JSON;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.decompilation.Decompiler;
import com.antgroup.antchain.myjava.backend.lowlevel.analyze.LowLevelInliningFilterFactory;
import com.antgroup.antchain.myjava.backend.lowlevel.dependency.StringsDependencyListener;
import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProvider;
import com.antgroup.antchain.myjava.backend.lowlevel.generate.NameProviderWithSpecialNames;
import com.antgroup.antchain.myjava.backend.lowlevel.transform.CoroutineTransformation;
import com.antgroup.antchain.myjava.backend.wasm.MyJavaWasmHost;
import com.antgroup.antchain.myjava.backend.wasm.binary.BinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmClassGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmDependencyListener;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerationContext;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmInteropFunctionGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmNameProvider;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmSpecialFunctionGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generate.WasmStringPool;
import com.antgroup.antchain.myjava.backend.wasm.generators.WasmMethodGenerator;
import com.antgroup.antchain.myjava.backend.wasm.generators.WasmMethodGeneratorContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.AddressIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.AllocatorIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.AnnotationIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.ConsoleIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.DoubleIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.ExceptionHandlingIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.FloatIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.FunctionIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.GCIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.IntegerIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.LongIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.MemoryTraceIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.MutatorIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.MychainLibIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.RuntimeClassIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.ShadowStackIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.StructureIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmHeapIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicFactory;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicFactoryContext;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmIntrinsicManager;
import com.antgroup.antchain.myjava.backend.wasm.intrinsics.WasmRuntimeIntrinsic;
import com.antgroup.antchain.myjava.backend.wasm.javautils.AbiParamTypeException;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfo;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfoField;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfoInterface;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiInfoStruct;
import com.antgroup.antchain.myjava.backend.wasm.javautils.MyContractAbiUtils;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmFunction;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmMemorySegment;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmModule;
import com.antgroup.antchain.myjava.backend.wasm.model.WasmType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBlock;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmBranch;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmCall;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmConditional;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmExpression;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmGetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Constant;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmInt32Subtype;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinary;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntBinaryOperation;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmIntType;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmLoadInt32;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmReturn;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmSetLocal;
import com.antgroup.antchain.myjava.backend.wasm.model.expression.WasmStoreInt32;
import com.antgroup.antchain.myjava.backend.wasm.optimization.StartOptimizer;
import com.antgroup.antchain.myjava.backend.wasm.optimization.UnusedFunctionElimination;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryRenderer;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryVersion;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmBinaryWriter;
import com.antgroup.antchain.myjava.backend.wasm.render.WasmRenderer;
import com.antgroup.antchain.myjava.backend.wasm.transformation.MemoryAccessTraceTransformation;
import com.antgroup.antchain.myjava.common.ServiceRepository;
import com.antgroup.antchain.myjava.dependency.ClassDependency;
import com.antgroup.antchain.myjava.dependency.DependencyAnalyzer;
import com.antgroup.antchain.myjava.dependency.DependencyListener;
import com.antgroup.antchain.myjava.diagnostics.Diagnostics;
import com.antgroup.antchain.myjava.interop.Address;
import com.antgroup.antchain.myjava.interop.ContractInterface;
import com.antgroup.antchain.myjava.interop.DelegateTo;
import com.antgroup.antchain.myjava.interop.Import;
import com.antgroup.antchain.myjava.interop.MyContract;
import com.antgroup.antchain.myjava.interop.NativeInNoJvm;
import com.antgroup.antchain.myjava.interop.StaticInit;
import com.antgroup.antchain.myjava.model.AnnotationContainerReader;
import com.antgroup.antchain.myjava.model.AnnotationHolder;
import com.antgroup.antchain.myjava.model.AnnotationReader;
import com.antgroup.antchain.myjava.model.AnnotationValue;
import com.antgroup.antchain.myjava.model.BasicBlock;
import com.antgroup.antchain.myjava.model.CallLocation;
import com.antgroup.antchain.myjava.model.ClassHierarchy;
import com.antgroup.antchain.myjava.model.ClassHolder;
import com.antgroup.antchain.myjava.model.ClassHolderTransformer;
import com.antgroup.antchain.myjava.model.ClassReader;
import com.antgroup.antchain.myjava.model.ClassReaderSource;
import com.antgroup.antchain.myjava.model.ElementModifier;
import com.antgroup.antchain.myjava.model.FieldReader;
import com.antgroup.antchain.myjava.model.FieldReference;
import com.antgroup.antchain.myjava.model.Instruction;
import com.antgroup.antchain.myjava.model.ListableClassHolderSource;
import com.antgroup.antchain.myjava.model.ListableClassReaderSource;
import com.antgroup.antchain.myjava.model.MethodDescriptor;
import com.antgroup.antchain.myjava.model.MethodHolder;
import com.antgroup.antchain.myjava.model.MethodReader;
import com.antgroup.antchain.myjava.model.MethodReference;
import com.antgroup.antchain.myjava.model.Program;
import com.antgroup.antchain.myjava.model.ValueType;
import com.antgroup.antchain.myjava.model.analysis.ClassMetadataRequirements;
import com.antgroup.antchain.myjava.model.classes.TagRegistry;
import com.antgroup.antchain.myjava.model.classes.VirtualTableBuilder;
import com.antgroup.antchain.myjava.model.classes.VirtualTableProvider;
import com.antgroup.antchain.myjava.model.instructions.CloneArrayInstruction;
import com.antgroup.antchain.myjava.model.instructions.InvocationType;
import com.antgroup.antchain.myjava.model.instructions.InvokeInstruction;
import com.antgroup.antchain.myjava.model.lowlevel.CallSiteDescriptor;
import com.antgroup.antchain.myjava.model.lowlevel.Characteristics;
import com.antgroup.antchain.myjava.model.lowlevel.CheckInstructionTransformation;
import com.antgroup.antchain.myjava.model.lowlevel.ClassInitializerEliminator;
import com.antgroup.antchain.myjava.model.lowlevel.ClassInitializerTransformer;
import com.antgroup.antchain.myjava.model.lowlevel.LowLevelNullCheckFilter;
import com.antgroup.antchain.myjava.model.lowlevel.ShadowStackTransformer;
import com.antgroup.antchain.myjava.model.lowlevel.WriteBarrierInsertion;
import com.antgroup.antchain.myjava.model.optimization.InliningFilterFactory;
import com.antgroup.antchain.myjava.model.transformation.BoundCheckInsertion;
import com.antgroup.antchain.myjava.model.transformation.ClassPatch;
import com.antgroup.antchain.myjava.model.transformation.NullCheckInsertion;
import com.antgroup.antchain.myjava.model.util.AsyncMethodFinder;
import com.antgroup.antchain.myjava.parsing.ClassRefsRenamer;
import com.antgroup.antchain.myjava.runtime.Allocator;
import com.antgroup.antchain.myjava.runtime.ExceptionHandling;
import com.antgroup.antchain.myjava.runtime.Fiber;
import com.antgroup.antchain.myjava.runtime.GC;
import com.antgroup.antchain.myjava.runtime.MemoryTraceRuntime;
import com.antgroup.antchain.myjava.runtime.MychainLib;
import com.antgroup.antchain.myjava.runtime.RuntimeArray;
import com.antgroup.antchain.myjava.runtime.RuntimeClass;
import com.antgroup.antchain.myjava.runtime.RuntimeObject;
import com.antgroup.antchain.myjava.runtime.ShadowStack;
import com.antgroup.antchain.myjava.runtime.WasmHeap;
import com.antgroup.antchain.myjava.runtime.WasmRuntime;
import com.antgroup.antchain.myjava.vm.BuildTarget;
import com.antgroup.antchain.myjava.vm.MyJavaEntryPoint;
import com.antgroup.antchain.myjava.vm.MyJavaTarget;
import com.antgroup.antchain.myjava.vm.MyJavaTargetController;
import com.antgroup.antchain.myjava.vm.spi.MyJavaHostExtension;
import com.antgroup.antchain.myjava.wasc.WascTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teavm.apachecommons.io.IOUtils;

public class WasmTarget
implements MyJavaTarget,
MyJavaWasmHost {
    private static final Logger log = LoggerFactory.getLogger(WasmTarget.class);
    private static boolean shouldLog = System.getProperty("com.antgroup.antchain.myjava.logDevirtualization", "false").equals("true");
    private static final MethodReference INIT_HEAP_REF = new MethodReference(WasmHeap.class, "initHeap", Address.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Void.TYPE);
    private static final MethodReference RESIZE_HEAP_REF = new MethodReference(WasmHeap.class, "resizeHeap", Integer.TYPE, Void.TYPE);
    private static final Set<MethodReference> VIRTUAL_METHODS = new HashSet<MethodReference>(Arrays.asList(new MethodReference(Object.class, "clone", Object.class)));
    private MyJavaTargetController controller;
    private Characteristics characteristics;
    private boolean debugging;
    private boolean wastEmitted;
    private boolean abiEmitted;
    private boolean wascEmitted;
    private boolean htmlEmitted;
    private boolean optimizeWasmStart;
    private boolean compressWasm = true;
    private int wasmSectionCode = 1;
    private boolean dumpNames = true;
    private boolean logClassEachSize;
    private ClassInitializerEliminator classInitializerEliminator;
    private ClassInitializerTransformer classInitializerTransformer;
    private ShadowStackTransformer shadowStackTransformer;
    private WriteBarrierInsertion writeBarrierInsertion;
    private WasmBinaryVersion version = WasmBinaryVersion.V_0x1;
    private List<WasmIntrinsicFactory> additionalIntrinsics = new ArrayList<WasmIntrinsicFactory>();
    private NullCheckInsertion nullCheckInsertion;
    private BoundCheckInsertion boundCheckInsertion = new BoundCheckInsertion();
    private CheckInstructionTransformation checkTransformation = new CheckInstructionTransformation();
    public static final int DEFAULT_MIN_HEAP_SIZE = 0x600000;
    public static final int DEFAULT_MAX_HEAP_SIZE = 0xE00000;
    public static final int DEFAULT_MAX_MEMORY_SIZE = 0x1000000;
    private int minHeapSize = 0x600000;
    private int maxHeapSize = 0xE00000;
    public int maxMemorySize = 0x1000000;
    private boolean enableMemoryTraceHooks = false;
    private boolean obfuscated;
    private Set<MethodReference> asyncMethods;
    private boolean hasThreads;
    private static final AtomicInteger startOptimizeRunTimes = new AtomicInteger(0);
    public static MyContractAbiInfo contractAbiInfo;

    @Override
    public void setController(MyJavaTargetController controller) {
        this.controller = controller;
        this.characteristics = new Characteristics(controller.getUnprocessedClassSource());
        this.classInitializerEliminator = new ClassInitializerEliminator(controller.getUnprocessedClassSource());
        this.classInitializerTransformer = new ClassInitializerTransformer();
        this.shadowStackTransformer = new ShadowStackTransformer(this.characteristics, true);
        this.nullCheckInsertion = new NullCheckInsertion(new LowLevelNullCheckFilter(this.characteristics));
        this.writeBarrierInsertion = new WriteBarrierInsertion(this.characteristics);
        controller.addVirtualMethods(VIRTUAL_METHODS::contains);
    }

    @Override
    public void add(WasmIntrinsicFactory intrinsic) {
        this.additionalIntrinsics.add(intrinsic);
    }

    @Override
    public List<MyJavaHostExtension> getHostExtensions() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean requiresRegisterAllocation() {
        return true;
    }

    @Override
    public List<ClassHolderTransformer> getTransformers() {
        ArrayList<ClassHolderTransformer> transformers = new ArrayList<ClassHolderTransformer>();
        transformers.add(new ClassPatch());
        transformers.add(new WasmDependencyListener(ClassRefsRenamer.getInstance()));
        return transformers;
    }

    @Override
    public List<DependencyListener> getDependencyListeners() {
        ArrayList<DependencyListener> listeners = new ArrayList<DependencyListener>();
        listeners.add(new WasmDependencyListener(ClassRefsRenamer.getInstance()));
        return listeners;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public void setWastEmitted(boolean wastEmitted) {
        this.wastEmitted = wastEmitted;
    }

    public void setAbiEmitted(boolean abiEmitted) {
        this.abiEmitted = abiEmitted;
    }

    public void setWascEmitted(boolean wascEmitted) {
        this.wascEmitted = wascEmitted;
    }

    public void setOptimizeWasmStart(boolean optimizeWasmStart) {
        this.optimizeWasmStart = optimizeWasmStart;
    }

    public void setCompressWasm(boolean compressWasm) {
        this.compressWasm = compressWasm;
    }

    public void setDumpNames(boolean dumpNames) {
        this.dumpNames = dumpNames;
    }

    public void setHtmlEmitted(boolean htmlEmitted) {
        this.htmlEmitted = htmlEmitted;
    }

    public void setWasmSectionCode(int wasmSectionCode) {
        this.wasmSectionCode = wasmSectionCode;
    }

    public void setLogClassEachSize(boolean logClassEachSize) {
        this.logClassEachSize = logClassEachSize;
    }

    public WasmBinaryVersion getVersion() {
        return this.version;
    }

    public void setVersion(WasmBinaryVersion version) {
        this.version = version;
    }

    public void setMinHeapSize(int minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setMaxMemorySize(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public void setEnableMemoryTraceHooks(boolean enableMemoryTraceHooks) {
        this.enableMemoryTraceHooks = enableMemoryTraceHooks;
        if (enableMemoryTraceHooks) {
            this.setOptimizeWasmStart(false);
        }
    }

    private void contributeMemoryTraceDependencies(DependencyAnalyzer dependencyAnalyzer) {
        if (!this.enableMemoryTraceHooks) {
            return;
        }
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "allocate", Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "free", Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "assertFree", Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "checkIsFree", Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "markStarted", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "mark", Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "markCompleted", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "move", Integer.TYPE, Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "gcStarted", Boolean.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "sweepStarted", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "sweepCompleted", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "gcCompleted", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(MemoryTraceRuntime.class, "resizeHeap", Integer.TYPE, Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
    }

    @Override
    public void contributeDependencies(DependencyAnalyzer dependencyAnalyzer) {
        MethodReference method;
        for (Class type : Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE)) {
            method = new MethodReference(WasmRuntime.class, "compare", type, type, Integer.TYPE);
            dependencyAnalyzer.linkMethod(method).use();
        }
        for (Class type : Arrays.asList(Float.TYPE, Double.TYPE)) {
            method = new MethodReference(WasmRuntime.class, "remainder", type, type, type);
            dependencyAnalyzer.linkMethod(method).use();
        }
        dependencyAnalyzer.linkMethod(new MethodReference(MychainLib.class, "saveContractAbiParam", Object.class, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "setWasmStartFuncCalled", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "align", Address.class, Integer.TYPE, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "fill", Address.class, Integer.TYPE, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "fillZero", Address.class, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "moveMemoryBlock", Address.class, Address.class, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "allocStack", Integer.TYPE, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getStackTop", Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getNextStackFrame", Address.class, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getStackRootCount", Address.class, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getStackRootPointer", Address.class, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "setExceptionHandlerId", Address.class, Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getCallSiteId", Address.class, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "resourceMapKeys", Address.class, String[].class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "lookupResource", Address.class, String.class, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "printlnString", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "printInt", Integer.TYPE, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "revert", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "abort", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "setReturnValue", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readInterfaceName", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readInterfaceParams", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readInterfaceNameSize", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readInterfaceParamsSize", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "checkAccount", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getBlockNumber", Long.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getBlockHash", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getBlockTimeStamp", Long.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getOrigin", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getAuthMap", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getAuthMapInCache", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getBalance", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getCode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getCodeHash", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getRecoverKey", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getAccountStatus", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getTxHash", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "transferBalance", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "log", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getGas", Long.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getValue", Long.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getDataSize", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getData", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getSender", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getSelf", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getRelatedTransactionListSize", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getRelatedTransactionList", Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readBuffer", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getTransaction", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getConfidentialDeposit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "createContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "isLocalTxEnv", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getDigestType", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "digest", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyRsa2", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "base64Encode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "base64Decode", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "ecrecovery", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyMessageSM2", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyMessageECCK1", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyMessageECCR1", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "bellmanSnarkVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "rangeProofVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "addPedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "subPedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "calculatePedersenCommit", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "pedersenCommitEqualityVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "liftedElgamalContractHomomorphicAdd", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "liftedElgamalContractHomomorphicSub", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "liftedElgamalScalarMutiply", Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "liftedElgamalContractZeroCheckVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "liftedElgamalContractRangeVerify", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "setStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getStorageSize", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "deleteStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "result", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getCallResultSize", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "getCallResult", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "readBufferRef", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyCommitment", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyRange", Integer.TYPE, Long.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "verifyBalance", Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "fTraceBegin", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "fTraceEnd", Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "deployContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "updateContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "updateContractStatus", Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "dcGetStorageSize", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "dcSetStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "dcDeleteStorage", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "dcSetAcl", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "grayscaleDeployContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "grayscaleVerification", Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "grayscaleVersionSwitchBack", Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "grayscaleUpdateContract", Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "callContract", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(WasmRuntime.class, "callEvm", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE)).use();
        dependencyAnalyzer.linkMethod(INIT_HEAP_REF).use();
        dependencyAnalyzer.linkMethod(RESIZE_HEAP_REF).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Allocator.class, "allocate", RuntimeClass.class, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Allocator.class, "allocateMultiArray", RuntimeClass.class, Address.class, Integer.TYPE, RuntimeArray.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Allocator.class, "<clinit>", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(ExceptionHandling.class, "throwException", Throwable.class, Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(ExceptionHandling.class, "catchException", Throwable.class)).use();
        dependencyAnalyzer.linkField(new FieldReference("java.lang.Object", "monitor"));
        dependencyAnalyzer.linkMethod(new MethodReference(String.class, "allocate", Integer.TYPE, String.class)).use();
        ClassDependency runtimeClassDep = dependencyAnalyzer.linkClass(RuntimeClass.class.getName());
        ClassDependency runtimeObjectDep = dependencyAnalyzer.linkClass(RuntimeObject.class.getName());
        ClassDependency runtimeArrayDep = dependencyAnalyzer.linkClass(RuntimeArray.class.getName());
        for (ClassDependency classDep : Arrays.asList(runtimeClassDep, runtimeObjectDep, runtimeArrayDep)) {
            for (FieldReader fieldReader : classDep.getClassReader().getFields()) {
                dependencyAnalyzer.linkField(fieldReader.getReference());
            }
        }
        dependencyAnalyzer.linkMethod(new MethodReference(Fiber.class, "isResuming", Boolean.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Fiber.class, "isSuspending", Boolean.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Fiber.class, "current", Fiber.class)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Fiber.class, "startMain", Void.TYPE)).use();
        dependencyAnalyzer.linkMethod(new MethodReference(Thread.class, "setCurrentThread", Thread.class, Void.TYPE)).use();
        ClassReader fiberClass = dependencyAnalyzer.getClassSource().get(Fiber.class.getName());
        for (MethodReader methodReader : fiberClass.getMethods()) {
            if (!methodReader.getName().startsWith("pop") && !methodReader.getName().equals("push")) continue;
            dependencyAnalyzer.linkMethod(methodReader.getReference()).use();
        }
        dependencyAnalyzer.addDependencyListener(new StringsDependencyListener());
        this.contributeMemoryTraceDependencies(dependencyAnalyzer);
    }

    @Override
    public void analyzeBeforeOptimizations(ListableClassReaderSource classSource) {
        AsyncMethodFinder asyncFinder = new AsyncMethodFinder(this.controller.getDependencyInfo().getCallGraph(), this.controller.getDependencyInfo());
        asyncFinder.find(classSource);
        this.asyncMethods = new HashSet<MethodReference>(asyncFinder.getAsyncMethods());
        this.asyncMethods.addAll(asyncFinder.getAsyncFamilyMethods());
        this.hasThreads = asyncFinder.hasAsyncMethods();
    }

    @Override
    public void beforeOptimizations(Program program, MethodReader method) {
        this.nullCheckInsertion.transformProgram(program, method.getReference());
        this.boundCheckInsertion.transformProgram(program, method.getReference());
    }

    @Override
    public void afterOptimizations(Program program, MethodReader method) {
        this.classInitializerEliminator.apply(program);
        this.classInitializerTransformer.transform(program);
        new CoroutineTransformation(this.controller.getUnprocessedClassSource(), this.asyncMethods, this.hasThreads).apply(program, method.getReference());
        this.checkTransformation.apply(program, method.getResultType());
        this.shadowStackTransformer.apply(program, method);
        this.writeBarrierInsertion.apply(program);
    }

    private MethodReference getFirstEntrypoint() {
        return this.controller.getEntryPoints().values().stream().findFirst().map(MyJavaEntryPoint::getMethod).orElse(null);
    }

    @Override
    public void emit(ListableClassHolderSource classes, BuildTarget buildTarget, String outputName, Set<MethodReader> linkClassStatic) throws IOException {
        WasmModule module = new WasmModule();
        WasmFunction initFunction = new WasmFunction("__start__");
        VirtualTableProvider vtableProvider = this.createVirtualTableProvider(classes);
        ClassHierarchy hierarchy = new ClassHierarchy(classes);
        TagRegistry tagRegistry = new TagRegistry(classes, hierarchy);
        BinaryWriter binaryWriter = new BinaryWriter(256);
        NameProviderWithSpecialNames names = new NameProviderWithSpecialNames(new WasmNameProvider(), this.controller.getUnprocessedClassSource(), hierarchy, this.getFirstEntrypoint());
        ClassMetadataRequirements metadataRequirements = new ClassMetadataRequirements(this.controller.getDependencyInfo());
        WasmClassGenerator classGenerator = new WasmClassGenerator(classes, this.controller.getUnprocessedClassSource(), vtableProvider, tagRegistry, binaryWriter, names, metadataRequirements, this.controller.getClassInitializerInfo());
        Decompiler decompiler = new Decompiler(classes, new HashSet<MethodReference>(), false);
        WasmStringPool stringPool = classGenerator.getStringPool();
        WasmGenerationContext context = new WasmGenerationContext(classes, module, this.controller.getDiagnostics(), vtableProvider, tagRegistry, stringPool, names);
        context.addIntrinsic(new AddressIntrinsic(classGenerator));
        context.addIntrinsic(new StructureIntrinsic(classes, classGenerator));
        context.addIntrinsic(new FunctionIntrinsic(classGenerator));
        WasmRuntimeIntrinsic wasmRuntimeIntrinsic = new WasmRuntimeIntrinsic();
        context.addIntrinsic(wasmRuntimeIntrinsic);
        context.addIntrinsic(new AllocatorIntrinsic(classGenerator));
        context.addIntrinsic(new RuntimeClassIntrinsic());
        context.addIntrinsic(new FloatIntrinsic());
        context.addIntrinsic(new DoubleIntrinsic());
        context.addIntrinsic(new LongIntrinsic());
        context.addIntrinsic(new IntegerIntrinsic());
        context.addIntrinsic(new ConsoleIntrinsic());
        context.addIntrinsic(new MychainLibIntrinsic());
        context.addIntrinsic(new AnnotationIntrinsic());
        context.addIntrinsic(new MemoryTraceIntrinsic(this.enableMemoryTraceHooks));
        context.addIntrinsic(new WasmHeapIntrinsic());
        context.addIntrinsic(new FiberIntrinsic());
        IntrinsicFactoryContext intrinsicFactoryContext = new IntrinsicFactoryContext();
        for (WasmIntrinsicFactory additionalIntrinsicFactory : this.additionalIntrinsics) {
            context.addIntrinsic(additionalIntrinsicFactory.create(intrinsicFactoryContext));
        }
        GCIntrinsic gcIntrinsic = new GCIntrinsic();
        context.addIntrinsic(gcIntrinsic);
        MutatorIntrinsic mutatorIntrinsic = new MutatorIntrinsic();
        context.addIntrinsic(mutatorIntrinsic);
        context.addIntrinsic(new ShadowStackIntrinsic());
        ExceptionHandlingIntrinsic exceptionHandlingIntrinsic = new ExceptionHandlingIntrinsic(binaryWriter, classGenerator, stringPool, this.obfuscated);
        context.addIntrinsic(exceptionHandlingIntrinsic);
        this.prepareGenerateDispatchFunction(classes, names, binaryWriter.getAddress());
        WasmGenerator generator = new WasmGenerator(decompiler, classes, context, classGenerator, binaryWriter, this.asyncMethods::contains);
        this.generateMethods(classes, context, generator, classGenerator, binaryWriter, module);
        classGenerator.updateClassConstructorsToClasses();
        new WasmInteropFunctionGenerator(classGenerator).generateFunctions(module);
        exceptionHandlingIntrinsic.postProcess(CallSiteDescriptor.extract(classes, classes.getClassNames()));
        this.generateIsSupertypeFunctions(tagRegistry, module, classGenerator);
        classGenerator.postProcess();
        new WasmSpecialFunctionGenerator(classGenerator).generateSpecialFunctions(module);
        mutatorIntrinsic.setStaticGcRootsAddress(classGenerator.getStaticGcRootsAddress());
        mutatorIntrinsic.setClassesAddress(classGenerator.getClassesAddress());
        mutatorIntrinsic.setClassCount(classGenerator.getClassCount());
        stringPool.resetStringClassReferences();
        WasmMemorySegment dataSegment = new WasmMemorySegment();
        dataSegment.setData(binaryWriter.getData());
        dataSegment.setOffset(256);
        module.getSegments().add(dataSegment);
        this.renderMemoryLayout(module, binaryWriter.getAddress(), gcIntrinsic);
        this.renderClinit(classes, classGenerator, module);
        if (this.controller.wasCancelled()) {
            return;
        }
        this.generateInitFunction(classes, initFunction, names, binaryWriter.getAddress());
        module.add(initFunction);
        module.setStartFunction(initFunction);
        module.add(this.createStartFunction(names));
        Object lastFunction = null;
        for (String functionName : classGenerator.getFunctionTable()) {
            Object function = module.getFunctions().get(functionName);
            if (function == null) {
                function = lastFunction;
            }
            assert (function != null) : "Function referenced from function table not found: " + functionName;
            module.getFunctionTable().add((WasmFunction)function);
            lastFunction = function;
        }
        Map<String, WasmFunction> lookWasmFunc = module.getFunctions();
        HashSet<WasmFunction> withRefectStaticFunc = new HashSet<WasmFunction>();
        for (MethodReader linkClassMethod : linkClassStatic) {
            String wasmFunc = names.forMethod(linkClassMethod.getReference());
            if (module.getFunctions().containsKey(wasmFunc)) {
                withRefectStaticFunc.add(lookWasmFunc.get(wasmFunc));
                continue;
            }
            throw new RuntimeException("can not find " + wasmFunc + " in wasm module");
        }
        new UnusedFunctionElimination(module, withRefectStaticFunc).apply();
        if (Boolean.parseBoolean(System.getProperty("wasm.memoryTrace", "false"))) {
            new MemoryAccessTraceTransformation(module).apply();
        }
        WasmBinaryWriter writer = new WasmBinaryWriter();
        WasmBinaryRenderer renderer = new WasmBinaryRenderer(writer, this.version, this.obfuscated);
        renderer.render(module, classGenerator.getClassBinarySizeCalculator());
        try (OutputStream output = buildTarget.createResource(outputName);){
            output.write(writer.getData());
            output.flush();
        }
        boolean optimizeStart = this.optimizeWasmStart;
        if (optimizeStart && startOptimizeRunTimes.incrementAndGet() > 10) {
            optimizeStart = false;
        }
        String wasmFileOutputName = outputName;
        if (optimizeStart) {
            String wasmPath = buildTarget.getFilePath(outputName);
            try {
                log.info("start snapshot wasm start function");
                StartOptimizer startOptimizer = new StartOptimizer(buildTarget, classGenerator, module, this.version, this.obfuscated, wasmPath, outputName);
                startOptimizer.apply();
                wasmFileOutputName = startOptimizer.getOutputWasmFileRelativePath();
                log.info("optimized start function successfuly to file " + buildTarget.getResourceFileDirectory(wasmFileOutputName));
            }
            catch (Exception e) {
                log.error("snapshot wasm start error", e);
                throw new RuntimeException(e);
            }
        }
        if (this.wastEmitted) {
            this.emitWast(module, buildTarget, this.getBaseName(outputName) + ".wast");
        }
        int contractVersion = 1;
        if (this.abiEmitted || this.wascEmitted) {
            contractVersion = this.emitContractAbiJson(classes, module, buildTarget, this.getBaseName(outputName) + ".abi").getContractVersion();
        }
        if (this.wascEmitted) {
            List<String> wasmFuncNames;
            List<WasmFunction> renderedFunctions = module.getRenderedFunctions();
            List<String> list = wasmFuncNames = renderedFunctions != null ? renderedFunctions.stream().map(WasmFunction::getName).collect(Collectors.toList()) : null;
            if (wasmFuncNames == null || wasmFuncNames.isEmpty()) {
                this.dumpNames = false;
            }
            this.emitWasc(buildTarget, contractVersion, this.compressWasm, this.getBaseName(wasmFileOutputName) + ".wasm", this.getBaseName(outputName) + ".abi", this.getBaseName(outputName) + ".wasc", this.dumpNames, wasmFuncNames);
        }
        if (this.htmlEmitted) {
            this.emitHtml(buildTarget, this.getBaseName(outputName) + ".html", this.getBaseName(outputName));
        }
        this.emitRuntime(buildTarget, this.getBaseName(outputName) + ".wasm-runtime.js");
    }

    private WasmFunction createStartFunction(NameProvider names) {
        WasmFunction function = new WasmFunction("myjava_start");
        function.setExportName("apply");
        function.setResult(WasmType.INT32);
        WasmCall call = new WasmCall(names.forMethod(new MethodReference(Fiber.class, "startMain", Void.TYPE)));
        function.getBody().add(call);
        function.getBody().add(new WasmInt32Constant(0));
        return function;
    }

    private void prepareGenerateDispatchFunction(ListableClassReaderSource classes, NameProvider names, int heapAddress) {
        MyContractAbiInfo contractAbiInfo;
        WasmTarget.contractAbiInfo = contractAbiInfo = this.generateContractAbiInfo(classes);
    }

    private void generateInitFunction(ListableClassReaderSource classes, WasmFunction initFunction, NameProvider names, int heapAddress) {
        MethodReader clinit;
        ClassReader cls;
        for (Class javaCls : new Class[]{WasmRuntime.class, WasmHeap.class}) {
            cls = classes.get(javaCls.getName());
            clinit = cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
            if (clinit == null) continue;
            initFunction.getBody().add(new WasmCall(names.forClassInitializer(cls.getName())));
        }
        log.info("heapAddress: " + heapAddress);
        if (heapAddress > this.maxMemorySize) {
            throw new RuntimeException("too large heapAddress " + heapAddress);
        }
        if ((double)this.minHeapSize < (double)heapAddress * 1.5) {
            throw new RuntimeException("too small min heap size when generated heap address " + heapAddress + ", need at least heapAddress * 1.5");
        }
        initFunction.getBody().add(new WasmCall(names.forMethod(INIT_HEAP_REF), new WasmInt32Constant(heapAddress), new WasmInt32Constant(this.minHeapSize), new WasmInt32Constant(this.maxHeapSize), new WasmInt32Constant(this.maxMemorySize), new WasmInt32Constant(262144)));
        for (Class javaCls : new Class[]{GC.class}) {
            cls = classes.get(javaCls.getName());
            clinit = cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
            if (clinit == null) continue;
            initFunction.getBody().add(new WasmCall(names.forClassInitializer(cls.getName())));
        }
        for (String className : classes.getClassNames()) {
            MethodReader clinit2;
            ClassReader cls2;
            if (className.equals(WasmRuntime.class.getName()) || className.equals(WasmHeap.class.getName()) || className.equals(GC.class.getName()) || (cls2 = classes.get(className)).getAnnotations().get(StaticInit.class.getName()) == null || (clinit2 = cls2.getMethod(new MethodDescriptor("<clinit>", Void.TYPE))) == null) continue;
            initFunction.getBody().add(new WasmCall(names.forClassInitializer(className)));
        }
        initFunction.getBody().add(new WasmCall(names.forMethod(new MethodReference(WasmRuntime.class, "setWasmStartFuncCalled", Void.TYPE))));
    }

    private String getBaseName(String name) {
        int index = name.lastIndexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    private void emitWast(WasmModule module, BuildTarget buildTarget, String outputName) throws IOException {
        WasmRenderer renderer = new WasmRenderer();
        renderer.setLineNumbersEmitted(this.debugging);
        renderer.render(module);
        try (OutputStream output = buildTarget.createResource(outputName);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            renderer.writeTo(writer);
        }
    }

    private MyContractAbiInfo generateContractAbiInfo(ListableClassReaderSource classes) {
        MyContractAbiInfo myContractAbiInfo = new MyContractAbiInfo();
        ArrayList<MyContractAbiInfoStruct> abiInfoStructs = new ArrayList<MyContractAbiInfoStruct>();
        ArrayList<MyContractAbiInfoInterface> abiInfoInterfaces = new ArrayList<MyContractAbiInfoInterface>();
        myContractAbiInfo.setStructs(abiInfoStructs);
        myContractAbiInfo.setInterfaces(abiInfoInterfaces);
        String testEntryPointClassName = "com.antgroup.antchain.myjava.junit.TestEntryPoint";
        boolean inJunitRunner = false;
        if (classes.get(testEntryPointClassName) != null) {
            inJunitRunner = true;
        }
        for (String clsName : classes.getClassNames()) {
            ClassReader clsReader;
            AnnotationContainerReader clsAnnos;
            AnnotationReader myContractAnno;
            if (inJunitRunner && !testEntryPointClassName.equals(clsName) || (myContractAnno = (clsAnnos = (clsReader = classes.get(clsName)).getAnnotations()).get(MyContract.class.getName())) == null) continue;
            AnnotationValue contractVersionValue = myContractAnno.getValue("version");
            int contractVersion = 1;
            if (contractVersionValue != null) {
                contractVersion = contractVersionValue.getInt();
            }
            myContractAbiInfo.setContractVersion(contractVersion);
            List<MethodReader> methods = classes.resolveNonConstructorClassMethodsWithExtendsExceptionObject(clsName);
            for (MethodReader method : methods) {
                String abiName;
                AnnotationContainerReader methodAnnos;
                AnnotationReader contractInterfaceAbi;
                if (method.hasModifier(ElementModifier.STATIC) || (contractInterfaceAbi = (methodAnnos = method.getAnnotations()).get(ContractInterface.class.getName())) == null) continue;
                AnnotationValue abiNameAnnoValue = contractInterfaceAbi.getValue("name");
                String string = abiName = abiNameAnnoValue != null ? abiNameAnnoValue.getString() : null;
                if (abiName == null) {
                    abiName = "";
                }
                if ((abiName = abiName.trim()).isEmpty()) {
                    abiName = method.getName();
                }
                ValueType[] methodParams = method.getParameterTypes();
                ValueType methodResultValueType = method.getResultType();
                try {
                    MyContractAbiInfoStruct abiStruct = new MyContractAbiInfoStruct();
                    abiStruct.setName(abiName);
                    abiStruct.setBase("");
                    boolean isVoidReturn = methodResultValueType.isObject(Void.class) || methodResultValueType.toString().equals("V");
                    abiStruct.setResults(isVoidReturn ? null : Arrays.asList(MyContractAbiUtils.valueTypeToAbiTypeName(methodResultValueType)));
                    abiStruct.setFields(Arrays.stream(methodParams).map(valueType -> {
                        MyContractAbiInfoField field = new MyContractAbiInfoField();
                        try {
                            String fieldTypeName = MyContractAbiUtils.valueTypeToAbiTypeName(valueType);
                            field.setName(fieldTypeName);
                            field.setType(fieldTypeName);
                            return field;
                        }
                        catch (AbiParamTypeException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList()));
                    abiInfoStructs.add(abiStruct);
                    MyContractAbiInfoInterface abiInterface = new MyContractAbiInfoInterface();
                    abiInterface.setName(abiName);
                    abiInterface.setType(abiName);
                    abiInterface.setMethod(method);
                    abiInfoInterfaces.add(abiInterface);
                    log.info("abi added interface " + abiName);
                }
                catch (AbiParamTypeException e) {
                    e.printStackTrace();
                }
            }
        }
        return myContractAbiInfo;
    }

    private MyContractAbiInfo emitContractAbiJson(ListableClassReaderSource classes, WasmModule module, BuildTarget buildTarget, String outputName) throws IOException {
        MyContractAbiInfo myContractAbiInfo = this.generateContractAbiInfo(classes);
        try (OutputStream output = buildTarget.createResource(outputName);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            writer.write(JSON.toJSONString((Object)myContractAbiInfo, true));
        }
        return myContractAbiInfo;
    }

    private void emitWasc(BuildTarget buildTarget, int contractVersion, boolean compressWasm, String wasmFileName, String abiJsonFileName, String outputName, boolean dumpNames, List<String> wasmFuncNames) throws IOException {
        try {
            WascTool.generateWascFile(contractVersion, this.wasmSectionCode, compressWasm, buildTarget.getFilePath(outputName), buildTarget.getFilePath(wasmFileName), buildTarget.getFilePath(abiJsonFileName), dumpNames, wasmFuncNames);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
    }

    private void emitRuntime(BuildTarget buildTarget, String outputName) throws IOException {
        ClassLoader loader = this.controller.getClassLoader();
        try (InputStream reader = loader.getResourceAsStream("com/antgroup/antchain/myjava/backend/wasm/wasm-runtime.js");
             OutputStreamWriter writer = new OutputStreamWriter(buildTarget.createResource(outputName), StandardCharsets.UTF_8);){
            String srcStr;
            String targetStr = srcStr = IOUtils.toString(reader, StandardCharsets.UTF_8);
            if (this.enableMemoryTraceHooks) {
                targetStr = srcStr.replace("const memoryTraceEnabled = false;", "const memoryTraceEnabled = true;");
            }
            writer.write(targetStr);
        }
    }

    private void emitHtml(BuildTarget buildTarget, String outputFile, String scriptName) throws IOException {
        ClassLoader loader = this.controller.getClassLoader();
        try (InputStream reader = loader.getResourceAsStream("com/antgroup/antchain/myjava/backend/wasm/wasm-demo.html");
             OutputStreamWriter writer = new OutputStreamWriter(buildTarget.createResource(outputFile), StandardCharsets.UTF_8);){
            String srcStr = IOUtils.toString(reader, StandardCharsets.UTF_8);
            String targetStr = srcStr.replace("${SCRIPT}", scriptName);
            writer.write(targetStr);
        }
    }

    private void generateMethods(ListableClassHolderSource classes, WasmGenerationContext context, WasmGenerator generator, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, WasmModule module) {
        ArrayList<MethodHolder> methods = new ArrayList<MethodHolder>();
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (!"<init>".equals(method.getName()) && (method.hasModifier(ElementModifier.ABSTRACT) || context.getIntrinsic(method.getReference()) != null)) continue;
                module.add(generator.generateDefinition(method.getReference()));
                methods.add(method);
            }
        }
        MethodGeneratorContextImpl methodGeneratorContext = new MethodGeneratorContextImpl(binaryWriter, context.getStringPool(), context.getDiagnostics(), context.names, classGenerator, classes);
        for (MethodHolder method : methods) {
            ClassHolder cls = classes.get(method.getOwnerName());
            MethodHolder implementor = method;
            AnnotationHolder delegateAnnot = method.getAnnotations().get(DelegateTo.class.getName());
            if (delegateAnnot != null) {
                String methodName = delegateAnnot.getValue("value").getString();
                boolean found = false;
                for (MethodHolder candidate : cls.getMethods()) {
                    if (!candidate.getName().equals(methodName)) continue;
                    if (found) {
                        this.controller.getDiagnostics().error(new CallLocation(method.getReference()), "Method is delegated to " + methodName + " but several implementations found", new Object[0]);
                        break;
                    }
                    implementor = candidate;
                    found = true;
                }
            }
            if (implementor.hasModifier(ElementModifier.NATIVE) || implementor.getAnnotations().get(NativeInNoJvm.class.getName()) != null) {
                WasmMethodGenerator methodGenerator = context.getGenerator(method.getReference());
                if (methodGenerator != null) {
                    WasmFunction function = context.getFunction(context.names.forMethod(method.getReference()));
                    methodGenerator.apply(method.getReference(), function, methodGeneratorContext);
                    continue;
                }
                if (this.isShadowStackMethod(method.getReference())) continue;
                if (context.getImportedMethod(method.getReference()) == null) {
                    CallLocation location = new CallLocation(method.getReference());
                    this.controller.getDiagnostics().error(location, "Method {{m0}} is native but has no {{c1}} annotation on it", method.getReference(), Import.class.getName());
                }
                generator.generateNative(method.getReference());
                continue;
            }
            if (implementor.getProgram() == null || implementor.getProgram().basicBlockCount() == 0) {
                if (!shouldLog) continue;
                log.info(String.format("method %s:%s implementor has no program found", implementor.getOwnerName(), implementor.getName()));
                continue;
            }
            if (method == implementor) {
                generator.generate(method.getReference(), implementor);
            } else {
                this.generateStub(context.names, module, method, implementor);
            }
            if (!this.controller.wasCancelled()) continue;
            return;
        }
    }

    private boolean isShadowStackMethod(MethodReference method) {
        if (!method.getClassName().equals(ShadowStack.class.getName())) {
            return false;
        }
        switch (method.getName()) {
            case "allocStack": 
            case "registerGCRoot": 
            case "removeGCRoot": 
            case "releaseStack": {
                return true;
            }
        }
        return false;
    }

    private void generateIsSupertypeFunctions(TagRegistry tagRegistry, WasmModule module, WasmClassGenerator classGenerator) {
        for (ValueType type : classGenerator.getRegisteredClasses()) {
            WasmIntBinary condition;
            WasmFunction function = new WasmFunction(classGenerator.names.forSupertypeFunction(type));
            function.getParameters().add(WasmType.INT32);
            function.setResult(WasmType.INT32);
            module.add(function);
            if (classGenerator.isAnnotationClass(type)) {
                int expected = classGenerator.getClassPointer(type);
                WasmLocal subtypeVar = new WasmLocal(WasmType.INT32, "subtype");
                function.add(subtypeVar);
                condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(subtypeVar), new WasmInt32Constant(expected));
                function.getBody().add(new WasmReturn(condition));
                continue;
            }
            WasmLocal subtypeVar = new WasmLocal(WasmType.INT32, "subtype");
            function.add(subtypeVar);
            if (type instanceof ValueType.Object) {
                String className = ((ValueType.Object)type).getClassName();
                this.generateIsClass(subtypeVar, classGenerator, tagRegistry, className, function.getBody());
                continue;
            }
            if (type instanceof ValueType.Array) {
                ValueType itemType = ((ValueType.Array)type).getItemType();
                this.generateIsArray(subtypeVar, classGenerator, itemType, function.getBody());
                continue;
            }
            int expected = classGenerator.getClassPointer(type);
            condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(subtypeVar), new WasmInt32Constant(expected));
            function.getBody().add(new WasmReturn(condition));
        }
    }

    private void generateIsClass(WasmLocal subtypeVar, WasmClassGenerator classGenerator, TagRegistry tagRegistry, String className, List<WasmExpression> body) {
        List<TagRegistry.Range> ranges = tagRegistry.getRanges(className);
        if (ranges.isEmpty()) {
            body.add(new WasmReturn(new WasmInt32Constant(0)));
            return;
        }
        int flagsOffset = classGenerator.getFieldOffset(new FieldReference(RuntimeClass.class.getName(), "flags"));
        WasmExpression flagsExpr = new WasmGetLocal(subtypeVar);
        flagsExpr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, flagsExpr, new WasmInt32Constant(flagsOffset));
        flagsExpr = new WasmLoadInt32(4, flagsExpr, WasmInt32Subtype.INT32);
        WasmIntBinary flagsPrimitive = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, flagsExpr, new WasmInt32Constant(2));
        WasmConditional testFlagsPrimitive = new WasmConditional(flagsPrimitive);
        testFlagsPrimitive.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testFlagsPrimitive);
        int tagOffset = classGenerator.getFieldOffset(new FieldReference(RuntimeClass.class.getName(), "tag"));
        WasmExpression tagExpression = new WasmGetLocal(subtypeVar);
        tagExpression = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, tagExpression, new WasmInt32Constant(tagOffset));
        tagExpression = new WasmLoadInt32(4, tagExpression, WasmInt32Subtype.INT32);
        body.add(new WasmSetLocal(subtypeVar, tagExpression));
        ranges.sort(Comparator.comparingInt(range -> range.lower));
        int lower = ranges.get((int)0).lower;
        int upper = ranges.get((int)(ranges.size() - 1)).upper;
        WasmIntBinary lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(lower));
        WasmConditional testLower = new WasmConditional(lowerCondition);
        testLower.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testLower);
        WasmIntBinary upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(upper));
        WasmConditional testUpper = new WasmConditional(upperCondition);
        testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
        body.add(testUpper);
        for (int i = 1; i < ranges.size(); ++i) {
            int lowerHole = ranges.get((int)(i - 1)).upper;
            int upperHole = ranges.get((int)i).lower;
            lowerCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GE_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(lowerHole));
            testLower = new WasmConditional(lowerCondition);
            body.add(testLower);
            upperCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(subtypeVar), new WasmInt32Constant(upperHole));
            testUpper = new WasmConditional(upperCondition);
            testUpper.getThenBlock().getBody().add(new WasmReturn(new WasmInt32Constant(0)));
            testLower.getThenBlock().getBody().add(testUpper);
        }
        body.add(new WasmReturn(new WasmInt32Constant(1)));
    }

    private void generateIsArray(WasmLocal subtypeVar, WasmClassGenerator classGenerator, ValueType itemType, List<WasmExpression> body) {
        int itemOffset = classGenerator.getFieldOffset(new FieldReference(RuntimeClass.class.getName(), "itemType"));
        WasmExpression itemExpression = new WasmGetLocal(subtypeVar);
        itemExpression = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, itemExpression, new WasmInt32Constant(itemOffset));
        itemExpression = new WasmLoadInt32(4, itemExpression, WasmInt32Subtype.INT32);
        body.add(new WasmSetLocal(subtypeVar, itemExpression));
        WasmIntBinary itemCondition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(subtypeVar), new WasmInt32Constant(0));
        WasmConditional itemTest = new WasmConditional(itemCondition);
        itemTest.setType(WasmType.INT32);
        itemTest.getThenBlock().getBody().add(new WasmInt32Constant(0));
        WasmCall delegateToItem = new WasmCall(classGenerator.names.forSupertypeFunction(itemType));
        delegateToItem.getArguments().add(new WasmGetLocal(subtypeVar));
        itemTest.getElseBlock().getBody().add(delegateToItem);
        body.add(new WasmReturn(itemTest));
    }

    private void generateStub(NameProvider names, WasmModule module, MethodHolder method, MethodHolder implementor) {
        WasmFunction function = module.getFunctions().get(names.forMethod(method.getReference()));
        WasmCall call = new WasmCall(names.forMethod(implementor.getReference()));
        for (WasmType param : function.getParameters()) {
            WasmLocal local = new WasmLocal(param);
            function.add(local);
            call.getArguments().add(new WasmGetLocal(local));
        }
        if (method.getResultType() == ValueType.VOID) {
            function.getBody().add(call);
        } else {
            function.getBody().add(new WasmReturn(call));
        }
    }

    private void renderClinit(ListableClassReaderSource classes, WasmClassGenerator classGenerator, WasmModule module) {
        for (ValueType type : classGenerator.getRegisteredClasses()) {
            MethodReader method;
            ClassReader cls;
            String className;
            if (!(type instanceof ValueType.Object) || classGenerator.isStructure(className = ((ValueType.Object)type).getClassName()) || (cls = classes.get(className)) == null || (method = cls.getMethod(new MethodDescriptor("<clinit>", Void.TYPE))) == null) continue;
            WasmFunction initFunction = new WasmFunction(classGenerator.names.forClassInitializer(className));
            module.add(initFunction);
            WasmBlock block = new WasmBlock(false);
            int index = classGenerator.getClassPointer(ValueType.object(className)) + classGenerator.getFieldOffset(new FieldReference(RuntimeClass.class.getName(), "flags"));
            WasmExpression initFlag = new WasmLoadInt32(4, new WasmInt32Constant(index), WasmInt32Subtype.INT32);
            initFlag = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.AND, initFlag, new WasmInt32Constant(1));
            block.getBody().add(new WasmBranch(initFlag, block));
            initFunction.getBody().add(block);
            initFlag = new WasmLoadInt32(4, new WasmInt32Constant(index), WasmInt32Subtype.INT32);
            initFlag = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.OR, initFlag, new WasmInt32Constant(1));
            block.getBody().add(new WasmStoreInt32(4, new WasmInt32Constant(index), initFlag, WasmInt32Subtype.INT32));
            block.getBody().add(new WasmCall(classGenerator.names.forMethod(method.getReference())));
            if (!this.controller.wasCancelled()) continue;
            break;
        }
    }

    private void renderMemoryLayout(WasmModule module, int address, GCIntrinsic gcIntrinsic) {
        module.setMinMemorySize(WasmRuntime.align(address, 65536) / 65536);
        int newStorageSize = WasmHeap.calculateStorageSize(this.maxHeapSize);
        int newRegionsCount = WasmHeap.calculateRegionsCount(this.maxHeapSize, 1024);
        int newRegionsSize = WasmHeap.calculateRegionsSize(newRegionsCount);
        address = WasmRuntime.align(address + 262144, 16);
        address = WasmRuntime.align(address + this.maxHeapSize, 16);
        address = WasmRuntime.align(address + newRegionsSize, 16);
        address = WasmRuntime.align(address + newRegionsCount, 16);
        address = WasmRuntime.align(address + newStorageSize, 16);
        int maxMemorySize = this.maxMemorySize / 65536;
        module.setMaxMemorySize(maxMemorySize);
    }

    private VirtualTableProvider createVirtualTableProvider(ListableClassHolderSource classes) {
        VirtualTableBuilder builder = new VirtualTableBuilder(classes);
        builder.setMethodsUsedAtCallSites(this.getMethodsUsedOnCallSites(classes));
        builder.setMethodCalledVirtually(this.controller::isVirtual);
        return builder.build();
    }

    private Set<MethodReference> getMethodsUsedOnCallSites(ListableClassHolderSource classes) {
        HashSet<MethodReference> virtualMethods = new HashSet<MethodReference>();
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                Program program = method.getProgram();
                if (program == null) continue;
                for (int i = 0; i < program.basicBlockCount(); ++i) {
                    BasicBlock block = program.basicBlockAt(i);
                    for (Instruction insn : block) {
                        if (insn instanceof InvokeInstruction) {
                            InvokeInstruction invoke = (InvokeInstruction)insn;
                            if (invoke.getType() != InvocationType.VIRTUAL) continue;
                            virtualMethods.add(invoke.getMethod());
                            continue;
                        }
                        if (!(insn instanceof CloneArrayInstruction)) continue;
                        virtualMethods.add(new MethodReference(Object.class, "clone", Object.class));
                    }
                }
            }
        }
        return virtualMethods;
    }

    @Override
    public String[] getPlatformTags() {
        return new String[]{"webassembly", "low_level"};
    }

    @Override
    public boolean isAsyncSupported() {
        return false;
    }

    @Override
    public InliningFilterFactory getInliningFilter() {
        return new LowLevelInliningFilterFactory(this.characteristics);
    }

    class FiberIntrinsic
    implements WasmIntrinsic {
        FiberIntrinsic() {
        }

        @Override
        public boolean isApplicable(WasmGenerationContext ctx, MethodReference methodReference) {
            if (!methodReference.getClassName().equals(Fiber.class.getName())) {
                return false;
            }
            switch (methodReference.getName()) {
                case "runMain": 
                case "setCurrentThread": {
                    return true;
                }
            }
            return false;
        }

        @Override
        public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
            switch (invocation.getMethod().getName()) {
                case "runMain": {
                    Iterator<? extends MyJavaEntryPoint> entryPointIter = WasmTarget.this.controller.getEntryPoints().values().iterator();
                    if (entryPointIter.hasNext()) {
                        MyJavaEntryPoint entryPoint = entryPointIter.next();
                        String name = manager.getNames().forMethod(entryPoint.getMethod());
                        WasmCall call = new WasmCall(name);
                        call.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                        call.setLocation(invocation.getLocation());
                        return call;
                    }
                    throw new RuntimeException("Can't find entrypoint class");
                }
                case "setCurrentThread": {
                    String name = manager.getNames().forMethod(new MethodReference(Thread.class, "setCurrentThread", Thread.class, Void.TYPE));
                    WasmCall call = new WasmCall(name);
                    call.getArguments().add(manager.generate(invocation.getArguments().get(0)));
                    call.setLocation(invocation.getLocation());
                    return call;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    static class MethodGeneratorContextImpl
    implements WasmMethodGeneratorContext {
        private BinaryWriter binaryWriter;
        private WasmStringPool stringPool;
        private Diagnostics diagnostics;
        private NameProvider names;
        private WasmClassGenerator classGenerator;
        private ClassReaderSource classSource;

        MethodGeneratorContextImpl(BinaryWriter binaryWriter, WasmStringPool stringPool, Diagnostics diagnostics, NameProvider names, WasmClassGenerator classGenerator, ClassReaderSource classSource) {
            this.binaryWriter = binaryWriter;
            this.stringPool = stringPool;
            this.diagnostics = diagnostics;
            this.names = names;
            this.classGenerator = classGenerator;
            this.classSource = classSource;
        }

        @Override
        public BinaryWriter getBinaryWriter() {
            return this.binaryWriter;
        }

        @Override
        public WasmStringPool getStringPool() {
            return this.stringPool;
        }

        @Override
        public Diagnostics getDiagnostics() {
            return this.diagnostics;
        }

        @Override
        public NameProvider getNames() {
            return this.names;
        }

        @Override
        public WasmClassGenerator getClassGenerator() {
            return this.classGenerator;
        }

        @Override
        public ClassReaderSource getClassSource() {
            return this.classSource;
        }
    }

    private class IntrinsicFactoryContext
    implements WasmIntrinsicFactoryContext {
        private IntrinsicFactoryContext() {
        }

        @Override
        public ClassReaderSource getClassSource() {
            return WasmTarget.this.controller.getUnprocessedClassSource();
        }

        @Override
        public ClassLoader getClassLoader() {
            return WasmTarget.this.controller.getClassLoader();
        }

        @Override
        public ServiceRepository getServices() {
            return WasmTarget.this.controller.getServices();
        }

        @Override
        public Properties getProperties() {
            return WasmTarget.this.controller.getProperties();
        }
    }
}

