/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.BlockStatement;
import com.antgroup.antchain.myjava.ast.BreakStatement;
import com.antgroup.antchain.myjava.ast.ContinueStatement;
import com.antgroup.antchain.myjava.ast.IdentifiedStatement;
import com.antgroup.antchain.myjava.ast.RecursiveVisitor;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.WhileStatement;
import java.util.HashSet;
import java.util.Set;

class RedundantLabelEliminator
extends RecursiveVisitor {
    private IdentifiedStatement currentBlock;
    private Set<IdentifiedStatement> hasRefs = new HashSet<IdentifiedStatement>();

    RedundantLabelEliminator() {
    }

    @Override
    public void visit(SwitchStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = statement;
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
        if (!this.hasRefs.contains(this.currentBlock)) {
            this.currentBlock.setId(null);
        }
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(WhileStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = statement;
        this.visit(statement.getBody());
        if (!this.hasRefs.contains(this.currentBlock)) {
            this.currentBlock.setId(null);
        }
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(BlockStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = null;
        this.visit(statement.getBody());
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(BreakStatement statement) {
        if (statement.getTarget() == this.currentBlock) {
            statement.setTarget(null);
        } else {
            this.hasRefs.add(statement.getTarget());
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        if (statement.getTarget() == this.currentBlock) {
            statement.setTarget(null);
        } else {
            this.hasRefs.add(statement.getTarget());
        }
    }
}

