/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.BinaryExpr;
import com.antgroup.antchain.myjava.ast.BinaryOperation;
import com.antgroup.antchain.myjava.ast.Expr;
import com.antgroup.antchain.myjava.ast.UnaryExpr;
import com.antgroup.antchain.myjava.ast.UnaryOperation;

final class ExprOptimizer {
    private ExprOptimizer() {
    }

    public static Expr invert(Expr expr) {
        if (expr instanceof UnaryExpr) {
            UnaryExpr unary = (UnaryExpr)expr;
            if (unary.getOperation() == UnaryOperation.NOT) {
                return unary.getOperand();
            }
        } else if (expr instanceof BinaryExpr) {
            BinaryExpr binary = (BinaryExpr)expr;
            Expr a = binary.getFirstOperand();
            Expr b = binary.getSecondOperand();
            switch (binary.getOperation()) {
                case EQUALS: {
                    return Expr.binary(BinaryOperation.NOT_EQUALS, binary.getType(), a, b, expr.getLocation());
                }
                case NOT_EQUALS: {
                    return Expr.binary(BinaryOperation.EQUALS, binary.getType(), a, b, expr.getLocation());
                }
                case LESS: {
                    return Expr.binary(BinaryOperation.GREATER_OR_EQUALS, binary.getType(), a, b, expr.getLocation());
                }
                case LESS_OR_EQUALS: {
                    return Expr.binary(BinaryOperation.GREATER, binary.getType(), a, b, expr.getLocation());
                }
                case GREATER: {
                    return Expr.binary(BinaryOperation.LESS_OR_EQUALS, binary.getType(), a, b, expr.getLocation());
                }
                case GREATER_OR_EQUALS: {
                    return Expr.binary(BinaryOperation.LESS, binary.getType(), a, b, expr.getLocation());
                }
            }
        }
        return Expr.invert(expr);
    }
}

