/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast.optimization;

import com.antgroup.antchain.myjava.ast.AbstractStatementVisitor;
import com.antgroup.antchain.myjava.ast.BlockStatement;
import com.antgroup.antchain.myjava.ast.BreakStatement;
import com.antgroup.antchain.myjava.ast.ConditionalStatement;
import com.antgroup.antchain.myjava.ast.ContinueStatement;
import com.antgroup.antchain.myjava.ast.IdentifiedStatement;
import com.antgroup.antchain.myjava.ast.ReturnStatement;
import com.antgroup.antchain.myjava.ast.SequentialStatement;
import com.antgroup.antchain.myjava.ast.Statement;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.ThrowStatement;
import com.antgroup.antchain.myjava.ast.TryCatchStatement;
import com.antgroup.antchain.myjava.ast.WhileStatement;
import com.antgroup.antchain.myjava.ast.optimization.AllBlocksCountVisitor;
import com.antgroup.antchain.myjava.ast.optimization.EscapingStatementFinder;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class BreakEliminator
extends AbstractStatementVisitor {
    private Map<BlockStatement, List<Statement>> blockSuccessors = new LinkedHashMap<BlockStatement, List<Statement>>();
    private Set<IdentifiedStatement> outerStatements = new LinkedHashSet<IdentifiedStatement>();
    private List<Statement> currentSequence;
    private int currentIndex;
    private AllBlocksCountVisitor usageCounter;

    BreakEliminator() {
    }

    public void eliminate(Statement statement) {
        this.usageCounter = new AllBlocksCountVisitor();
        statement.acceptVisitor(this.usageCounter);
        statement.acceptVisitor(this);
    }

    private void processSequence(List<Statement> statements) {
        List<Statement> oldSequence = this.currentSequence;
        int oldIndex = this.currentIndex;
        this.currentSequence = statements;
        this.currentIndex = 0;
        while (this.currentIndex < this.currentSequence.size()) {
            statements.get(this.currentIndex).acceptVisitor(this);
            ++this.currentIndex;
        }
        this.currentIndex = oldIndex;
        this.currentSequence = oldSequence;
    }

    @Override
    public void visit(SequentialStatement statement) {
        if (this.currentSequence == null) {
            this.processSequence(statement.getSequence());
            return;
        }
        --this.currentIndex;
        this.currentSequence.remove(this.currentIndex);
        this.currentSequence.addAll(this.currentIndex, statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.processSequence(statement.getConsequent());
        this.processSequence(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        this.outerStatements.add(statement);
        for (SwitchClause clause : statement.getClauses()) {
            this.processSequence(clause.getBody());
        }
        this.processSequence(statement.getDefaultClause());
        this.outerStatements.remove(statement);
    }

    @Override
    public void visit(WhileStatement statement) {
        this.outerStatements.add(statement);
        this.processSequence(statement.getBody());
        this.outerStatements.remove(statement);
    }

    @Override
    public void visit(BlockStatement statement) {
        this.outerStatements.add(statement);
        if (!this.escapes(this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()))) {
            this.blockSuccessors.put(statement, this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()));
        }
        this.processSequence(statement.getBody());
        this.blockSuccessors.remove(statement);
        this.outerStatements.remove(statement);
    }

    @Override
    public void visit(BreakStatement statement) {
        if (this.blockSuccessors.containsKey(statement.getTarget()) && this.usageCounter.getCount(statement.getTarget()) == 1) {
            this.currentSequence.subList(this.currentIndex, this.currentSequence.size()).clear();
            List<Statement> successors = this.blockSuccessors.remove(statement.getTarget());
            this.currentSequence.addAll(successors);
            successors.clear();
            --this.currentIndex;
            return;
        }
        this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()).clear();
    }

    @Override
    public void visit(ContinueStatement statement) {
        this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()).clear();
    }

    @Override
    public void visit(ReturnStatement statement) {
        this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()).clear();
    }

    @Override
    public void visit(ThrowStatement statement) {
        this.currentSequence.subList(this.currentIndex + 1, this.currentSequence.size()).clear();
    }

    @Override
    public void visit(TryCatchStatement statement) {
        Map<BlockStatement, List<Statement>> oldBlockSuccessors = this.blockSuccessors;
        Set<IdentifiedStatement> oldOuterStatements = this.outerStatements;
        this.outerStatements = new LinkedHashSet<IdentifiedStatement>();
        this.blockSuccessors = new LinkedHashMap<BlockStatement, List<Statement>>();
        this.processSequence(statement.getProtectedBody());
        this.outerStatements = oldOuterStatements;
        this.blockSuccessors = oldBlockSuccessors;
        this.processSequence(statement.getHandler());
    }

    private boolean escapes(List<Statement> statements) {
        return new EscapingStatementFinder(this.usageCounter).check(statements);
    }
}

