/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.antchain.myjava.ast;

import com.antgroup.antchain.myjava.ast.ArrayFromDataExpr;
import com.antgroup.antchain.myjava.ast.AssignmentStatement;
import com.antgroup.antchain.myjava.ast.BinaryExpr;
import com.antgroup.antchain.myjava.ast.BlockStatement;
import com.antgroup.antchain.myjava.ast.BoundCheckExpr;
import com.antgroup.antchain.myjava.ast.BreakStatement;
import com.antgroup.antchain.myjava.ast.CastExpr;
import com.antgroup.antchain.myjava.ast.ConditionalExpr;
import com.antgroup.antchain.myjava.ast.ConditionalStatement;
import com.antgroup.antchain.myjava.ast.ConstantExpr;
import com.antgroup.antchain.myjava.ast.ContinueStatement;
import com.antgroup.antchain.myjava.ast.Expr;
import com.antgroup.antchain.myjava.ast.ExprVisitor;
import com.antgroup.antchain.myjava.ast.GotoPartStatement;
import com.antgroup.antchain.myjava.ast.InitClassStatement;
import com.antgroup.antchain.myjava.ast.InstanceOfExpr;
import com.antgroup.antchain.myjava.ast.InvocationExpr;
import com.antgroup.antchain.myjava.ast.MonitorEnterStatement;
import com.antgroup.antchain.myjava.ast.MonitorExitStatement;
import com.antgroup.antchain.myjava.ast.NewArrayExpr;
import com.antgroup.antchain.myjava.ast.NewExpr;
import com.antgroup.antchain.myjava.ast.NewMultiArrayExpr;
import com.antgroup.antchain.myjava.ast.PrimitiveCastExpr;
import com.antgroup.antchain.myjava.ast.QualificationExpr;
import com.antgroup.antchain.myjava.ast.ReturnStatement;
import com.antgroup.antchain.myjava.ast.SequentialStatement;
import com.antgroup.antchain.myjava.ast.Statement;
import com.antgroup.antchain.myjava.ast.StatementVisitor;
import com.antgroup.antchain.myjava.ast.SubscriptExpr;
import com.antgroup.antchain.myjava.ast.SwitchClause;
import com.antgroup.antchain.myjava.ast.SwitchStatement;
import com.antgroup.antchain.myjava.ast.ThrowStatement;
import com.antgroup.antchain.myjava.ast.TryCatchStatement;
import com.antgroup.antchain.myjava.ast.UnaryExpr;
import com.antgroup.antchain.myjava.ast.UnwrapArrayExpr;
import com.antgroup.antchain.myjava.ast.VariableExpr;
import com.antgroup.antchain.myjava.ast.WhileStatement;
import java.util.List;

public class RecursiveVisitor
implements ExprVisitor,
StatementVisitor {
    protected boolean canceled;

    protected void beforeVisit(Expr expr) {
    }

    protected void afterVisit(Expr expr) {
    }

    protected final void cancel() {
        this.canceled = true;
    }

    @Override
    public void visit(BinaryExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getFirstOperand().acceptVisitor(this);
            if (!this.canceled) {
                expr.getSecondOperand().acceptVisitor(this);
            }
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(UnaryExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getOperand().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (statement.getLeftValue() != null) {
            statement.getLeftValue().acceptVisitor(this);
            if (this.canceled) {
                return;
            }
        }
        statement.getRightValue().acceptVisitor(this);
    }

    @Override
    public void visit(ConditionalExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getCondition().acceptVisitor(this);
            if (!this.canceled) {
                expr.getConsequent().acceptVisitor(this);
                if (!this.canceled) {
                    expr.getAlternative().acceptVisitor(this);
                }
            }
        }
        this.afterVisit(expr);
    }

    public void visit(List<Statement> statements) {
        for (Statement part : statements) {
            part.acceptVisitor(this);
            if (!this.canceled) continue;
            break;
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConstantExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(ConditionalStatement statement) {
        statement.getCondition().acceptVisitor(this);
        this.visit(statement.getConsequent());
        if (!this.canceled) {
            this.visit(statement.getAlternative());
        }
    }

    @Override
    public void visit(VariableExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(SubscriptExpr expr) {
        this.beforeVisit(expr);
        expr.getArray().acceptVisitor(this);
        if (!this.canceled) {
            expr.getIndex().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getValue().acceptVisitor(this);
        if (this.canceled) {
            return;
        }
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
            if (!this.canceled) continue;
            return;
        }
        if (!this.canceled) {
            this.visit(statement.getDefaultClause());
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getArray().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(WhileStatement statement) {
        if (statement.getCondition() != null) {
            statement.getCondition().acceptVisitor(this);
            if (this.canceled) {
                return;
            }
        }
        this.visit(statement.getBody());
    }

    @Override
    public void visit(InvocationExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            for (Expr argument : expr.getArguments()) {
                argument.acceptVisitor(this);
                if (!this.canceled) continue;
                break;
            }
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(BlockStatement statement) {
        this.visit(statement.getBody());
    }

    @Override
    public void visit(QualificationExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled && expr.getQualified() != null) {
            expr.getQualified().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(NewExpr expr) {
        this.beforeVisit(expr);
        this.afterVisit(expr);
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NewArrayExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getLength().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            for (Expr dimension : expr.getDimensions()) {
                dimension.acceptVisitor(this);
                if (!this.canceled) continue;
                break;
            }
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(ArrayFromDataExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            for (Expr element : expr.getData()) {
                element.acceptVisitor(this);
                if (!this.canceled) continue;
                break;
            }
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            statement.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getExpr().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
    }

    @Override
    public void visit(CastExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getValue().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getValue().acceptVisitor(this);
        }
        this.afterVisit(expr);
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        statement.getObjectRef().acceptVisitor(this);
    }

    @Override
    public void visit(BoundCheckExpr expr) {
        this.beforeVisit(expr);
        if (!this.canceled) {
            expr.getIndex().acceptVisitor(this);
            if (!this.canceled && expr.getArray() != null) {
                expr.getArray().acceptVisitor(this);
            }
        }
        this.afterVisit(expr);
    }
}

