/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.test.anno;

import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.JetCacheBaseBeans;
import com.alicp.jetcache.anno.support.SpringConfigProvider;
import com.alicp.jetcache.embedded.LinkedHashMapCacheBuilder;
import com.alicp.jetcache.external.MockRemoteCacheBuilder;
import com.alicp.jetcache.support.Fastjson2KeyConvertor;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.KryoValueEncoder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;

public class TestUtil {
    public static GlobalCacheConfig createGloableConfig() {
        HashMap<String, LinkedHashMapCacheBuilder.LinkedHashMapCacheBuilderImpl> localBuilders = new HashMap<String, LinkedHashMapCacheBuilder.LinkedHashMapCacheBuilderImpl>();
        LinkedHashMapCacheBuilder.LinkedHashMapCacheBuilderImpl localBuilder = LinkedHashMapCacheBuilder.createLinkedHashMapCacheBuilder();
        localBuilder.setKeyConvertor((Function)Fastjson2KeyConvertor.INSTANCE);
        localBuilders.put("default", localBuilder);
        localBuilders.put("A1", localBuilder);
        HashMap<String, MockRemoteCacheBuilder.MockRemoteCacheBuilderImpl> remoteBuilders = new HashMap<String, MockRemoteCacheBuilder.MockRemoteCacheBuilderImpl>();
        MockRemoteCacheBuilder.MockRemoteCacheBuilderImpl remoteBuilder = MockRemoteCacheBuilder.createMockRemoteCacheBuilder();
        remoteBuilder.setKeyConvertor((Function)Fastjson2KeyConvertor.INSTANCE);
        remoteBuilder.setValueEncoder((Function)KryoValueEncoder.INSTANCE);
        remoteBuilder.setValueDecoder((Function)KryoValueDecoder.INSTANCE);
        remoteBuilder.setBroadcastChannel("mockBroadcastChannel");
        remoteBuilders.put("default", remoteBuilder);
        remoteBuilder = MockRemoteCacheBuilder.createMockRemoteCacheBuilder();
        remoteBuilder.setKeyConvertor((Function)Fastjson2KeyConvertor.INSTANCE);
        remoteBuilder.setValueEncoder((Function)KryoValueEncoder.INSTANCE);
        remoteBuilder.setValueDecoder((Function)KryoValueDecoder.INSTANCE);
        remoteBuilder.setBroadcastChannel("mockBroadcastChannel_A1");
        remoteBuilders.put("A1", remoteBuilder);
        GlobalCacheConfig globalCacheConfig = new GlobalCacheConfig();
        globalCacheConfig.setLocalCacheBuilders(localBuilders);
        globalCacheConfig.setRemoteCacheBuilders(remoteBuilders);
        return globalCacheConfig;
    }

    public static SpringConfigProvider createConfigProvider() {
        JetCacheBaseBeans baseBeans = new JetCacheBaseBeans();
        SpringConfigProvider configProvider = baseBeans.springConfigProvider(null, TestUtil.createGloableConfig(), null, null, null);
        baseBeans.cacheManager((ConfigProvider)configProvider);
        return configProvider;
    }

    public static void waitUtil(Supplier<Boolean> condition) {
        TestUtil.waitUtil(Boolean.TRUE, condition);
    }

    public static void waitUtil(Object expectValue, Supplier<? extends Object> actual) {
        TestUtil.waitUtil(expectValue, actual, 5000L);
    }

    public static void waitUtil(Object expectValue, Supplier<? extends Object> actual, long timeoutMillis) {
        long start = System.nanoTime();
        long deadline = start + timeoutMillis * 1000L * 1000L;
        Object obj = actual.get();
        if (Objects.equals(expectValue, obj)) {
            return;
        }
        int waitCount = 0;
        while (deadline - System.nanoTime() > 0L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++waitCount;
            obj = actual.get();
            if (!Objects.equals(expectValue, obj)) continue;
            return;
        }
        throw new AssertionFailedError("expect: " + expectValue + ", actual:" + obj + ", timeout=" + timeoutMillis + "ms, cost=" + (System.nanoTime() - start) / 1000L / 1000L + "ms, waitCount=" + waitCount);
    }
}

