/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.test.spring;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.template.QuickConfig;
import com.alicp.jetcache.test.beans.FactoryBeanTarget;
import com.alicp.jetcache.test.beans.Service;
import com.alicp.jetcache.test.beans.TestBean;
import com.alicp.jetcache.test.spring.SpringTestBase;
import com.alicp.jetcache.test.support.DynamicQuery;
import com.alicp.jetcache.test.support.DynamicQueryWithEquals;
import java.util.UUID;
import org.junit.Assert;

public class SpringTest
extends SpringTestBase {
    protected void doTest() throws Exception {
        Service service = (Service)this.context.getBean("service");
        TestBean bean = (TestBean)this.context.getBean("testBean");
        this.testService(service, bean);
        this.testTestBean(bean);
        FactoryBeanTarget target = (FactoryBeanTarget)this.context.getBean("factoryBeanTarget");
        Assert.assertEquals((long)target.count(), (long)target.count());
        this.testCacheManager();
    }

    private void testService(Service service, TestBean bean) throws Exception {
        Assert.assertNotEquals((long)service.notCachedCount(), (long)service.notCachedCount());
        Assert.assertEquals((long)service.countWithAnnoOnClass(), (long)service.countWithAnnoOnClass());
        Assert.assertEquals((long)service.countWithAnnoOnInterface(), (long)service.countWithAnnoOnInterface());
        Assert.assertNotEquals((long)service.enableCacheWithNoCacheCount(bean), (long)service.enableCacheWithNoCacheCount(bean));
        Assert.assertEquals((long)service.enableCacheWithAnnoOnClass(bean), (long)service.enableCacheWithAnnoOnClass(bean));
        Assert.assertEquals((long)service.enableCacheWithAnnoOnInterface(bean), (long)service.enableCacheWithAnnoOnInterface(bean));
        int v1 = service.count("K1");
        Assert.assertEquals((long)v1, (long)service.count("K1"));
        service.delete("K1");
        int v2 = service.count("K1");
        Assert.assertNotEquals((long)v1, (long)v2);
        service.delete2("K1");
        Assert.assertEquals((long)v2, (long)service.count("K1"));
        service.update("K1", 200);
        Assert.assertEquals((long)200L, (long)service.count("K1"));
        service.update2("K1", 300);
        Assert.assertEquals((long)200L, (long)service.count("K1"));
        Assert.assertEquals((long)service.count("K1"), (long)service.count("K1"));
        Assert.assertNotEquals((long)service.count("K1"), (long)service.count("K2"));
    }

    private void testTestBean(TestBean bean) throws Exception {
        Assert.assertNotEquals((long)bean.noCacheCount(), (long)bean.noCacheCount());
        Assert.assertEquals((long)bean.staticCount(), (long)bean.staticCount());
        Assert.assertEquals((long)bean.count(), (long)bean.count());
        Assert.assertEquals((long)bean.countWithLocalCache(), (long)bean.countWithLocalCache());
        Assert.assertEquals((long)bean.countWithBoth(), (long)bean.countWithBoth());
        Assert.assertNotEquals((long)bean.countWithDisabledCache(), (long)bean.countWithDisabledCache());
        int x = bean.countWithExpire50();
        Assert.assertEquals((long)x, (long)bean.countWithExpire50());
        Thread.sleep(50L);
        Assert.assertNotEquals((long)x, (long)bean.countWithExpire50());
        DynamicQuery q1 = new DynamicQuery();
        q1.setId(1000L);
        q1.setName("N1");
        DynamicQuery q2 = new DynamicQuery();
        q2.setId(1000L);
        q2.setName("N2");
        DynamicQuery q3 = new DynamicQuery();
        q3.setId(1000L);
        q3.setName("N1");
        int x1 = bean.countLocalWithDynamicQuery(q1);
        int x2 = bean.countLocalWithDynamicQuery(q2);
        int x3 = bean.countLocalWithDynamicQuery(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        x1 = bean.countRemoteWithDynamicQuery(q1);
        x2 = bean.countRemoteWithDynamicQuery(q2);
        x3 = bean.countRemoteWithDynamicQuery(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        x1 = bean.countLocalWithDynamicQueryAndKeyConvertor(q1);
        x2 = bean.countLocalWithDynamicQueryAndKeyConvertor(q2);
        x3 = bean.countLocalWithDynamicQueryAndKeyConvertor(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        DynamicQueryWithEquals dqwe1 = new DynamicQueryWithEquals();
        dqwe1.setId(1000L);
        dqwe1.setName("N1");
        DynamicQueryWithEquals dqwe2 = new DynamicQueryWithEquals();
        dqwe2.setId(1001L);
        dqwe2.setName("N2");
        DynamicQueryWithEquals dqwe3 = new DynamicQueryWithEquals();
        dqwe3.setId(1000L);
        dqwe3.setName("N1");
        x1 = bean.countLocalWithDynamicQueryWithEquals(dqwe1);
        x2 = bean.countLocalWithDynamicQueryWithEquals(dqwe2);
        x3 = bean.countLocalWithDynamicQueryWithEquals(dqwe3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        Assert.assertEquals((long)bean.countEnabledWithConfigBean(), (long)bean.countEnabledWithConfigBean());
        Assert.assertNotEquals((long)bean.countDisabledWithConfigBean(), (long)bean.countDisabledWithConfigBean());
        Assert.assertNotEquals((long)bean.countWithWrongCondition(), (long)bean.countWithWrongCondition());
        Assert.assertEquals((long)bean.count(true), (long)bean.count(true));
        Assert.assertNotEquals((long)bean.count(false), (long)bean.count(false));
        Assert.assertNotEquals((long)bean.count(), (long)bean.count1());
        Assert.assertEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount1_WithNameN1());
        Assert.assertEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount2_WithNameN1());
        Assert.assertNotEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount_WithNameN2());
        Assert.assertEquals((long)bean.namedCount_WithNameN2(), (long)bean.namedCount_WithNameN2());
        int v1 = bean.count("K1");
        Assert.assertEquals((long)v1, (long)bean.count("K1"));
        bean.delete("K1");
        int v2 = bean.count("K1");
        Assert.assertNotEquals((long)v1, (long)v2);
        bean.delete2("K1");
        Assert.assertEquals((long)v2, (long)bean.count("K1"));
        bean.update("K1", 200);
        Assert.assertEquals((long)200L, (long)bean.count("K1"));
        bean.update2("K1", 300);
        Assert.assertEquals((long)200L, (long)bean.count("K1"));
        Assert.assertEquals((long)bean.count("K1"), (long)bean.count("K1"));
        Assert.assertNotEquals((long)bean.count("K1"), (long)bean.count("K2"));
    }

    private void testCacheManager() {
        String cacheName = UUID.randomUUID().toString();
        CacheManager cm = (CacheManager)this.context.getBean(CacheManager.class);
        Cache c = cm.getOrCreateCache(QuickConfig.newBuilder((String)cacheName).build());
        Cache c2 = cm.getCache("default", cacheName);
        Assert.assertSame((Object)c, (Object)c2);
    }
}

