/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.test;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.test.support.DynamicQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.junit.Assert;

public abstract class AbstractCacheTest {
    protected Cache<Object, Object> cache;
    boolean asyncTestFail = false;
    private volatile boolean cocurrentFail = false;
    private volatile AtomicLong lockCount1;
    private volatile AtomicLong lockCount2;
    private volatile AtomicLong lockAtommicCount1;
    private volatile AtomicLong lockAtommicCount2;

    protected void baseTest() throws Exception {
        this.illegalArgTest();
        Assert.assertEquals((Object)CacheResultCode.NOT_EXISTS, (Object)this.cache.GET((Object)"BASE_K1").getResultCode());
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.PUT((Object)"BASE_K1", (Object)"V1", 10L, TimeUnit.SECONDS).getResultCode());
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.GET((Object)"BASE_K1").getResultCode());
        Assert.assertEquals((Object)"V1", (Object)this.cache.GET((Object)"BASE_K1").getValue());
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.PUT((Object)"BASE_K1", (Object)"V2", 10L, TimeUnit.SECONDS).getResultCode());
        Assert.assertEquals((Object)"V2", (Object)this.cache.GET((Object)"BASE_K1").getValue());
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.REMOVE((Object)"BASE_K1").getResultCode());
        Assert.assertEquals((Object)CacheResultCode.NOT_EXISTS, (Object)this.cache.GET((Object)"BASE_K1").getResultCode());
        this.cache.put((Object)"BASE_K2", null);
        CacheGetResult r = this.cache.GET((Object)"BASE_K2");
        Assert.assertTrue((boolean)r.isSuccess());
        Assert.assertNull((Object)r.getValue());
        this.getAllTest();
        this.putAllTest();
        this.removeAllTest();
        this.computeIfAbsentTest();
        this.lockTest();
        this.putIfAbsentTest();
        this.complextValueTest();
        this.asyncTest();
        AbstractCacheTest.penetrationProtectTest(this.cache);
    }

    private void illegalArgTest() {
        block5: {
            Assert.assertNull((Object)this.cache.get(null));
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.GET(null).getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.GET(null).getMessage());
            Assert.assertNull((Object)this.cache.getAll(null));
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.GET_ALL(null).getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.GET_ALL(null).getMessage());
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.PUT(null, (Object)"V1").getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.PUT(null, (Object)"V1").getMessage());
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.PUT(null, (Object)"V1", 1L, TimeUnit.SECONDS).getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.PUT(null, (Object)"V1", 1L, TimeUnit.SECONDS).getMessage());
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.PUT_ALL(null).getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.PUT_ALL(null).getMessage());
            Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.PUT_ALL(null, 1L, TimeUnit.SECONDS).getResultCode());
            Assert.assertEquals((Object)"illegal argument", (Object)this.cache.PUT_ALL(null, 1L, TimeUnit.SECONDS).getMessage());
            try {
                Assert.assertFalse((boolean)this.cache.putIfAbsent(null, (Object)"V1"));
                Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.PUT_IF_ABSENT(null, (Object)"V1", 1L, TimeUnit.SECONDS).getResultCode());
                Assert.assertEquals((Object)"illegal argument", (Object)this.cache.PUT_IF_ABSENT(null, (Object)"V1", 1L, TimeUnit.SECONDS).getMessage());
            }
            catch (UnsupportedOperationException e) {
                Cache c = this.cache;
                while (c instanceof ProxyCache) {
                    c = ((ProxyCache)c).getTargetCache();
                }
                if (c instanceof MultiLevelCache) break block5;
                Assert.fail();
            }
        }
        Assert.assertFalse((boolean)this.cache.remove(null));
        Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.REMOVE(null).getResultCode());
        Assert.assertEquals((Object)"illegal argument", (Object)this.cache.REMOVE(null).getMessage());
        Assert.assertEquals((Object)CacheResultCode.FAIL, (Object)this.cache.REMOVE_ALL(null).getResultCode());
        Assert.assertEquals((Object)"illegal argument", (Object)this.cache.REMOVE_ALL(null).getMessage());
        try {
            this.cache.unwrap(String.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.cache.tryLock(null, 1L, TimeUnit.SECONDS));
        this.cache.tryLockAndRun(null, 1L, TimeUnit.SECONDS, () -> Assert.fail());
    }

    private void getAllTest() {
        String k1 = "getAllTest_K1";
        String k2 = "getAllTest_K2";
        String k3 = "getAllTest_K3";
        HashSet<String> s = new HashSet<String>();
        s.add(k1);
        s.add(k2);
        s.add(k3);
        this.cache.put((Object)k1, (Object)"V1");
        this.cache.put((Object)k2, (Object)"V2");
        MultiGetResult r = this.cache.GET_ALL(s);
        Assert.assertTrue((boolean)r.isSuccess());
        Assert.assertEquals((long)3L, (long)r.getValues().size());
        Assert.assertTrue((boolean)((CacheGetResult)r.getValues().get(k1)).isSuccess());
        Assert.assertEquals((Object)"V1", (Object)((CacheGetResult)r.getValues().get(k1)).getValue());
        Assert.assertTrue((boolean)((CacheGetResult)r.getValues().get(k2)).isSuccess());
        Assert.assertEquals((Object)"V2", (Object)((CacheGetResult)r.getValues().get(k2)).getValue());
        Assert.assertEquals((Object)CacheResultCode.NOT_EXISTS, (Object)((CacheGetResult)r.getValues().get(k3)).getResultCode());
        Assert.assertNull((Object)((CacheGetResult)r.getValues().get(k3)).getValue());
        Map map = this.cache.getAll(s);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((Object)"V1", map.get(k1));
        Assert.assertEquals((Object)"V2", map.get(k2));
        Assert.assertNull(map.get(k3));
        Assert.assertEquals((long)0L, (long)this.cache.getAll(Collections.emptySet()).size());
    }

    private void putAllTest() throws Exception {
        String k1 = "putAllTest_K1";
        String k2 = "putAllTest_K2";
        String k3 = "putAllTest_K3";
        String k4 = "putAllTest_K4";
        String k5 = "putAllTest_K5";
        String k6 = "putAllTest_K6";
        String k7 = "putAllTest_K7";
        String k8 = "putAllTest_K8";
        String k9 = "putAllTest_K9";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(k1, "V1");
        m.put(k2, "V2");
        m.put(k3, "V3");
        Assert.assertTrue((boolean)this.cache.PUT_ALL(m).isSuccess());
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)k1));
        Assert.assertEquals((Object)"V2", (Object)this.cache.get((Object)k2));
        Assert.assertEquals((Object)"V3", (Object)this.cache.get((Object)k3));
        m.clear();
        m.put(k4, "V4");
        m.put(k5, "V5");
        m.put(k6, "V6");
        this.cache.putAll(m);
        Assert.assertEquals((Object)"V4", (Object)this.cache.get((Object)k4));
        Assert.assertEquals((Object)"V5", (Object)this.cache.get((Object)k5));
        Assert.assertEquals((Object)"V6", (Object)this.cache.get((Object)k6));
        m.clear();
        m.put(k7, "V7");
        m.put(k8, "V8");
        m.put(k9, "V9");
        Assert.assertTrue((boolean)this.cache.PUT_ALL(m, 5000L, TimeUnit.MILLISECONDS).isSuccess());
        Assert.assertEquals((Object)"V7", (Object)this.cache.get((Object)k7));
        Assert.assertEquals((Object)"V8", (Object)this.cache.get((Object)k8));
        Assert.assertEquals((Object)"V9", (Object)this.cache.get((Object)k9));
        m.clear();
        m.put(k7, "V77");
        m.put(k8, "V88");
        m.put(k9, "V99");
        this.cache.putAll(m, 5000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"V77", (Object)this.cache.get((Object)k7));
        Assert.assertEquals((Object)"V88", (Object)this.cache.get((Object)k8));
        Assert.assertEquals((Object)"V99", (Object)this.cache.get((Object)k9));
    }

    private void removeAllTest() {
        String k1 = "removeAllTest_K1";
        String k2 = "removeAllTest_K2";
        String k3 = "removeAllTest_K3";
        this.cache.put((Object)k1, (Object)"V1");
        this.cache.put((Object)k2, (Object)"V2");
        this.cache.put((Object)k3, (Object)"V3");
        HashSet<String> s = new HashSet<String>();
        s.add(k1);
        s.add(k2);
        this.cache.removeAll(s);
        Assert.assertNull((Object)this.cache.get((Object)k1));
        Assert.assertNull((Object)this.cache.get((Object)k2));
        Assert.assertNotNull((Object)this.cache.get((Object)k3));
        s = new HashSet();
        s.add(k1);
        s.add(k3);
        Assert.assertTrue((boolean)this.cache.REMOVE_ALL(s).isSuccess());
        Assert.assertNull((Object)this.cache.get((Object)k1));
        Assert.assertNull((Object)this.cache.get((Object)k2));
        Assert.assertNull((Object)this.cache.get((Object)k3));
    }

    private boolean isMultiLevelCache() {
        Cache c = this.cache;
        while (c instanceof ProxyCache) {
            c = ((ProxyCache)c).getTargetCache();
        }
        return c instanceof MultiLevelCache;
    }

    private void putIfAbsentTest() throws Exception {
        if (this.isMultiLevelCache()) {
            return;
        }
        Assert.assertTrue((boolean)this.cache.putIfAbsent((Object)"PIA_K1", (Object)"V1"));
        Assert.assertFalse((boolean)this.cache.putIfAbsent((Object)"PIA_K1", (Object)"V1"));
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)"PIA_K1"));
        Assert.assertTrue((boolean)this.cache.remove((Object)"PIA_K1"));
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.PUT_IF_ABSENT((Object)"PIA_K2", (Object)"V2", 10L, TimeUnit.SECONDS).getResultCode());
        Assert.assertEquals((Object)CacheResultCode.EXISTS, (Object)this.cache.PUT_IF_ABSENT((Object)"PIA_K2", (Object)"V2", 10L, TimeUnit.SECONDS).getResultCode());
        Assert.assertEquals((Object)"V2", (Object)this.cache.get((Object)"PIA_K2"));
        Assert.assertTrue((boolean)this.cache.remove((Object)"PIA_K2"));
        Assert.assertTrue((boolean)this.cache.PUT_IF_ABSENT((Object)"PIA_K3", (Object)"V3", 5L, TimeUnit.MILLISECONDS).isSuccess());
        Thread.sleep(10L);
        Assert.assertTrue((boolean)this.cache.PUT_IF_ABSENT((Object)"PIA_K3", (Object)"V3", 5L, TimeUnit.MILLISECONDS).isSuccess());
        this.cache.remove((Object)"PIA_K3");
    }

    private void computeIfAbsentTest() {
        this.cache.put((Object)"CIA_K1", (Object)"V");
        this.cache.computeIfAbsent((Object)"CIA_K1", k -> {
            throw new RuntimeException();
        });
        Assert.assertEquals((Object)"AAA", (Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_1", k -> "AAA"));
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_2", k -> null));
        Object[] invoked = new Object[1];
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_2", k -> {
            invoked[0] = new Object();
            return null;
        }));
        Assert.assertNotNull((Object)invoked[0]);
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_3", k -> null, true));
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_3", k -> {
            throw new RuntimeException();
        }, true));
        this.cache.put((Object)"CIA_K2", (Object)"V");
        this.cache.computeIfAbsent((Object)"CIA_K2", k -> {
            throw new RuntimeException();
        }, false, 1L, TimeUnit.MINUTES);
        Assert.assertEquals((Object)"AAA", (Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_11", k -> "AAA", false, 1L, TimeUnit.MINUTES));
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_22", k -> null, false, 1L, TimeUnit.MINUTES));
        invoked = new Object[1];
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_22", k -> {
            invoked[0] = new Object();
            return null;
        }));
        Assert.assertNotNull((Object)invoked[0]);
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_33", k -> null, true, 1L, TimeUnit.MINUTES));
        Assert.assertNull((Object)this.cache.computeIfAbsent((Object)"CIA_NOT_EXIST_33", k -> {
            throw new RuntimeException();
        }, true, 1L, TimeUnit.MINUTES));
    }

    private void asyncTest() throws Exception {
        CacheResult putResult = this.cache.PUT((Object)"async_K1", (Object)"V1");
        putResult.future().thenAccept(resultData -> {
            if (resultData.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
        });
        putResult.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
        CacheGetResult getResult = this.cache.GET((Object)"async_K1");
        getResult.future().thenAccept(resultData -> {
            if (resultData.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
            if (!"V1".equals(resultData.getData())) {
                this.asyncTestFail = true;
            }
        });
        getResult.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
        CacheGetResult getResult2 = this.cache.GET((Object)"async_K1");
        getResult2.future().thenRun(() -> {
            if (!"V1".equals(getResult2.getValue())) {
                this.asyncTestFail = true;
            }
        });
        getResult2.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
        HashSet<String> s = new HashSet<String>();
        s.add("async_K1");
        s.add("async_K2");
        MultiGetResult multiGetResult = this.cache.GET_ALL(s);
        multiGetResult.future().thenAccept(resultData -> {
            if (resultData.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
            Map m = (Map)resultData.getData();
            CacheGetResult r1 = (CacheGetResult)m.get("async_K1");
            CacheGetResult r2 = (CacheGetResult)m.get("async_K2");
            if (r1.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
            if (r2.getResultCode() != CacheResultCode.NOT_EXISTS) {
                this.asyncTestFail = true;
            }
            if (!"V1".equals(r1.getValue())) {
                this.asyncTestFail = true;
            }
            if (r2.getValue() != null) {
                this.asyncTestFail = true;
            }
        });
        multiGetResult.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
        MultiGetResult multiGetResult2 = this.cache.GET_ALL(s);
        multiGetResult2.future().thenRun(() -> {
            Map m;
            if (multiGetResult2.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
            if (!"V1".equals((m = multiGetResult2.unwrapValues()).get("async_K1"))) {
                this.asyncTestFail = true;
            }
            if (m.get("async_K2") != null) {
                this.asyncTestFail = true;
            }
        });
        multiGetResult2.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
        CacheResult removeResult = this.cache.REMOVE((Object)"async_K1");
        removeResult.future().thenAccept(resultData -> {
            if (resultData.getResultCode() != CacheResultCode.SUCCESS) {
                this.asyncTestFail = true;
            }
        });
        removeResult.future().toCompletableFuture().get();
        Assert.assertFalse((boolean)this.asyncTestFail);
    }

    private void complextValueTest() {
        A a1 = new A();
        A a2 = new A();
        A a3 = new A();
        a1.id = 100;
        a2.id = 100;
        a3.id = 101;
        a1.name = "N1";
        a1.name = "N2";
        a1.name = "N3";
        this.cache.put((Object)"CVT_K1", (Object)a1);
        A fromCache = (A)this.cache.get((Object)"CVT_K1");
        Assert.assertEquals((Object)a2, (Object)fromCache);
        Assert.assertNotEquals((Object)a3, (Object)fromCache);
    }

    protected void lockTest() throws Exception {
        try (AutoReleaseLock lock = this.cache.tryLock((Object)"LockKey1", 200L, TimeUnit.HOURS);){
            Assert.assertNotNull((Object)lock);
            Assert.assertNull((Object)this.cache.tryLock((Object)"LockKey1", 200L, TimeUnit.HOURS));
            Assert.assertNotNull((Object)this.cache.tryLock((Object)"LockKey2", 200L, TimeUnit.MILLISECONDS));
        }
        Assert.assertNotNull((Object)this.cache.tryLock((Object)"LockKey1", 50L, TimeUnit.MILLISECONDS));
        Assert.assertNull((Object)this.cache.tryLock((Object)"LockKey1", 50L, TimeUnit.MILLISECONDS));
        Thread.sleep(51L);
        Assert.assertNotNull((Object)this.cache.tryLock((Object)"LockKey1", 50L, TimeUnit.MILLISECONDS));
        int count = 10;
        CountDownLatch countDownLatch = new CountDownLatch(count);
        int[] runCount = new int[2];
        Runnable runnable = () -> {
            boolean b = this.cache.tryLockAndRun((Object)"LockKeyAndRunKey", 10L, TimeUnit.SECONDS, () -> {
                runCount[1] = runCount[1] + 1;
                while (countDownLatch.getCount() > 1L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            if (b) {
                runCount[0] = runCount[0] + 1;
            }
            countDownLatch.countDown();
        };
        for (int i = 0; i < count; ++i) {
            new Thread(runnable).start();
        }
        countDownLatch.await();
        Assert.assertEquals((long)1L, (long)runCount[0]);
        Assert.assertEquals((long)1L, (long)runCount[1]);
        try {
            this.cache.tryLockAndRun((Object)"LockKeyAndRunKey", 10L, TimeUnit.SECONDS, () -> {
                throw new RuntimeException();
            });
            Assert.fail();
        }
        catch (Exception e) {
            try (AutoReleaseLock lock = this.cache.tryLock((Object)"LockKeyAndRunKey", 1L, TimeUnit.SECONDS);){
                Assert.assertNotNull((Object)lock);
            }
        }
    }

    protected void expireAfterWriteTest(long ttl) throws InterruptedException {
        this.cache.put((Object)"EXPIRE_W_K1", (Object)"V1");
        this.expireAfterWriteTestImpl("EXPIRE_W_K1", ttl);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("EXPIRE_W_K2", "V1");
        this.cache.PUT_ALL(m);
        this.expireAfterWriteTestImpl("EXPIRE_W_K2", ttl);
        this.cache.put((Object)"EXPIRE_W_K3", (Object)"V1", ttl /= 2L, TimeUnit.MILLISECONDS);
        this.expireAfterWriteTestImpl("EXPIRE_W_K3", ttl);
        m = new HashMap();
        m.put("EXPIRE_W_K4", "V1");
        this.cache.PUT_ALL(m, ttl, TimeUnit.MILLISECONDS);
        this.expireAfterWriteTestImpl("EXPIRE_W_K4", ttl);
    }

    protected void expireAfterAccessTest(long ttl) throws InterruptedException {
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)this.cache.PUT((Object)"EXPIRE_A_K1", (Object)"V1").getResultCode());
        this.expireAfterAccessTestImpl("EXPIRE_A_K1", ttl);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("EXPIRE_W_K2", "V1");
        this.cache.PUT_ALL(m);
        this.expireAfterAccessTestImpl("EXPIRE_W_K2", ttl);
        m = new HashMap();
        m.put("EXPIRE_W_K4", "V1");
        this.cache.PUT_ALL(m);
        this.expireAfterAccessTestImpl("EXPIRE_W_K4", ttl);
    }

    protected void expireAfterWriteTestImpl(String key, long ttl) throws InterruptedException {
        CacheGetResult r = this.cache.GET((Object)key);
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)r.getResultCode());
        Assert.assertEquals((Object)"V1", (Object)r.getValue());
        Thread.sleep(ttl / 2L);
        r = this.cache.GET((Object)key);
        Assert.assertEquals((Object)CacheResultCode.SUCCESS, (Object)r.getResultCode());
        Assert.assertEquals((Object)"V1", (Object)r.getValue());
        Thread.sleep(ttl / 2L + 2L);
        r = this.cache.GET((Object)key);
        Assert.assertTrue((r.getResultCode() == CacheResultCode.EXPIRED || r.getResultCode() == CacheResultCode.NOT_EXISTS ? 1 : 0) != 0);
        Assert.assertNull((Object)r.getValue());
    }

    protected void expireAfterAccessTestImpl(String key, long ttl) throws InterruptedException {
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)key));
        Thread.sleep(ttl / 2L);
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)key));
        Thread.sleep(ttl / 2L + 2L);
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)key));
        Thread.sleep(ttl + 1L);
        CacheGetResult r = this.cache.GET((Object)key);
        Assert.assertTrue((r.getResultCode() == CacheResultCode.EXPIRED || r.getResultCode() == CacheResultCode.NOT_EXISTS ? 1 : 0) != 0);
        Assert.assertNull((Object)r.getValue());
    }

    protected void fastjsonKeyCoverterTest() {
        DynamicQuery d1 = new DynamicQuery();
        DynamicQuery d2 = new DynamicQuery();
        DynamicQuery d3 = new DynamicQuery();
        d1.setId(100L);
        d2.setId(100L);
        d3.setId(101L);
        d1.setName("HL");
        d2.setName("HL");
        this.cache.put((Object)d1, (Object)"V1");
        Assert.assertEquals((Object)"V1", (Object)this.cache.get((Object)d2));
        Assert.assertNull((Object)this.cache.get((Object)d3));
    }

    protected void concurrentTest(int threadCount, int limit, int timeInMillis) throws Exception {
        this.concurrentTest(threadCount, limit * 5, timeInMillis, true);
        this.concurrentTest(threadCount, limit, timeInMillis, false);
    }

    private void concurrentTest(int threadCount, int limit, int timeInMillis, final boolean overflow) throws Exception {
        int i;
        final int count = limit / threadCount;
        this.lockAtommicCount1 = new AtomicLong();
        this.lockAtommicCount2 = new AtomicLong();
        this.lockCount1 = new AtomicLong();
        this.lockCount2 = new AtomicLong();
        final CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        class T
        extends Thread {
            private String keyPrefix;
            private transient boolean stop;
            private Random random = new Random();

            T(String keyPrefix) {
                this.keyPrefix = keyPrefix;
            }

            private void task1() {
                int i = 0;
                while (!this.stop) {
                    if (++i >= count) {
                        i = 0;
                    }
                    String key = this.keyPrefix + i;
                    Integer value = this.random.nextInt(10);
                    AbstractCacheTest.this.cache.PUT((Object)key, (Object)value, 10000L, TimeUnit.SECONDS);
                    CacheGetResult result = AbstractCacheTest.this.cache.GET((Object)key);
                    this.checkResult(key, value, result);
                    CacheResult removeResult = AbstractCacheTest.this.cache.REMOVE((Object)key);
                    Assert.assertTrue((removeResult.isSuccess() || removeResult.getResultCode() == CacheResultCode.NOT_EXISTS ? 1 : 0) != 0);
                    if (!AbstractCacheTest.this.isMultiLevelCache()) {
                        AbstractCacheTest.this.cache.putIfAbsent((Object)String.valueOf(i), (Object)i);
                    }
                    String k1 = String.valueOf(i);
                    String k2 = key;
                    HashMap<String, Integer> m = new HashMap<String, Integer>();
                    m.put(k1, value);
                    value = value + 1;
                    m.put(k2, value);
                    Assert.assertTrue((boolean)AbstractCacheTest.this.cache.PUT_ALL(m).isSuccess());
                    MultiGetResult multiGetResult = AbstractCacheTest.this.cache.GET_ALL(m.keySet());
                    Assert.assertTrue((boolean)multiGetResult.isSuccess());
                    this.checkResult(k2, value, (CacheGetResult)multiGetResult.getValues().get(k2));
                    Assert.assertTrue((boolean)AbstractCacheTest.this.cache.REMOVE_ALL(m.keySet()).isSuccess());
                }
            }

            private void task2() throws Exception {
                while (!this.stop) {
                    boolean b = this.random.nextBoolean();
                    String lockKey = b ? "lock1" : "lock2";
                    AutoReleaseLock lock = AbstractCacheTest.this.cache.tryLock((Object)lockKey, 10L, TimeUnit.SECONDS);
                    Throwable throwable = null;
                    try {
                        if (lock == null) continue;
                        int x = this.random.nextInt(10);
                        AtomicLong lockAtomicCount = b ? AbstractCacheTest.this.lockAtommicCount1 : AbstractCacheTest.this.lockAtommicCount2;
                        AtomicLong lockCount = b ? AbstractCacheTest.this.lockCount1 : AbstractCacheTest.this.lockCount2;
                        String shareKey = lockKey + "_share";
                        lockAtomicCount.addAndGet(x);
                        long lockCountNum = lockCount.get();
                        AbstractCacheTest.this.cache.put((Object)shareKey, (Object)x);
                        Assert.assertEquals((Object)x, (Object)AbstractCacheTest.this.cache.get((Object)shareKey));
                        Assert.assertTrue((boolean)AbstractCacheTest.this.cache.remove((Object)shareKey));
                        if (b) {
                            AbstractCacheTest.this.putIfAbsentTest();
                        }
                        lockCount.set(lockCountNum + (long)x);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (lock == null) continue;
                        if (throwable != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        lock.close();
                    }
                }
            }

            @Override
            public void run() {
                try {
                    if (overflow) {
                        this.task1();
                    } else {
                        this.task2();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    AbstractCacheTest.this.cocurrentFail = true;
                }
                countDownLatch.countDown();
            }

            private void checkResult(String key, Integer value, CacheGetResult result) {
                if (result.getResultCode() != CacheResultCode.SUCCESS && result.getResultCode() != CacheResultCode.NOT_EXISTS) {
                    System.out.println("key:" + key + ",code:" + result.getResultCode());
                    AbstractCacheTest.this.cocurrentFail = true;
                }
                if (result.isSuccess() && !result.getValue().equals(value)) {
                    System.out.println("key:" + key + ",value:" + result.getValue());
                    AbstractCacheTest.this.cocurrentFail = true;
                }
            }
        }
        T[] t = new T[threadCount];
        for (i = 0; i < threadCount; ++i) {
            t[i] = new T("T" + i + "_");
            t[i].setName("ConTest" + i);
            t[i].start();
        }
        Thread.sleep(timeInMillis);
        for (i = 0; i < threadCount; ++i) {
            t[i].stop = true;
        }
        countDownLatch.await();
        Assert.assertEquals((long)this.lockAtommicCount1.get(), (long)this.lockCount1.get());
        Assert.assertEquals((long)this.lockAtommicCount2.get(), (long)this.lockCount2.get());
        Assert.assertFalse((boolean)this.cocurrentFail);
    }

    public static void penetrationProtectTest(Cache cache) throws Exception {
        boolean oldPenetrationProtect = cache.config().isCachePenetrationProtect();
        cache.config().setCachePenetrationProtect(true);
        AbstractCacheTest.penetrationProtectTestWithComputeIfAbsent(cache);
        if (cache instanceof LoadingCache) {
            AbstractCacheTest.penetrationProtectTestWithLoadingCache(cache);
        }
        cache.config().setCachePenetrationProtect(oldPenetrationProtect);
    }

    private static void penetrationProtectTestWithComputeIfAbsent(Cache cache) throws Exception {
        final String keyPrefix = "penetrationProtect_";
        final AtomicInteger loadSuccess = new AtomicInteger(0);
        Function loader = new Function(){
            private AtomicInteger count1 = new AtomicInteger(0);
            private AtomicInteger count2 = new AtomicInteger(0);

            public Object apply(Object k) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if ((keyPrefix + "1").equals(k) ? this.count1.getAndIncrement() <= 1 : (keyPrefix + "2").equals(k) && this.count2.getAndIncrement() <= 2) {
                    throw new RuntimeException("mock error");
                }
                loadSuccess.incrementAndGet();
                return k + "_V";
            }
        };
        int threadCount = 20;
        CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        AtomicInteger getFailCount = new AtomicInteger(0);
        AtomicBoolean fail = new AtomicBoolean(false);
        int i = 0;
        while (i < threadCount) {
            int index = i++;
            Thread t = new Thread(() -> {
                String key = keyPrefix + index % 3;
                try {
                    Object o = cache.computeIfAbsent((Object)key, loader);
                    if (!o.equals(key + "_V")) {
                        fail.set(true);
                    }
                }
                catch (Throwable e) {
                    if (!"mock error".equals(e.getMessage())) {
                        e.printStackTrace();
                    }
                    getFailCount.incrementAndGet();
                }
                countDownLatch.countDown();
            });
            t.start();
        }
        countDownLatch.await();
        Assert.assertFalse((boolean)fail.get());
        Assert.assertEquals((long)3L, (long)loadSuccess.get());
        Assert.assertEquals((long)5L, (long)getFailCount.get());
        cache.remove((Object)(keyPrefix + "0"));
        cache.remove((Object)(keyPrefix + "1"));
        cache.remove((Object)(keyPrefix + "2"));
    }

    private static void penetrationProtectTestWithLoadingCache(Cache cache) throws Exception {
        final String[] failMsg = new String[1];
        Function<Integer, Integer> loaderFunction = new Function<Integer, Integer>(){
            ConcurrentHashMap<Integer, Integer> map = new ConcurrentHashMap();

            @Override
            public Integer apply(Integer key) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.map.get(key) == null) {
                    this.map.put(key, key);
                } else {
                    failMsg[0] = "each key should load only once";
                }
                return key + 100;
            }
        };
        CacheLoader loader = k -> (Integer)loaderFunction.apply((Integer)k);
        CacheLoader oldLoader = cache.config().getLoader();
        cache.config().setLoader(loader);
        CountDownLatch countDownLatch = new CountDownLatch(5);
        Cache c = cache;
        new Thread(() -> {
            if ((Integer)c.get((Object)2000) != 2100) {
                failMsg[0] = "value error";
            }
            countDownLatch.countDown();
        }).start();
        new Thread(() -> {
            if ((Integer)c.get((Object)2000) != 2100) {
                failMsg[0] = "value error";
            }
            countDownLatch.countDown();
        }).start();
        new Thread(() -> {
            if ((Integer)c.get((Object)2001) != 2101) {
                failMsg[0] = "value error";
            }
            countDownLatch.countDown();
        }).start();
        new Thread(() -> {
            if ((Integer)c.computeIfAbsent((Object)2001, loaderFunction) != 2101) {
                failMsg[0] = "value error";
            }
            countDownLatch.countDown();
        }).start();
        new Thread(() -> {
            HashSet<Integer> s = new HashSet<Integer>();
            s.add(2001);
            s.add(2002);
            Map values = c.getAll(s);
            if ((Integer)values.get(2001) != 2101) {
                failMsg[0] = "value error";
            }
            if ((Integer)values.get(2002) != 2102) {
                failMsg[0] = "value error";
            }
            countDownLatch.countDown();
        }).start();
        countDownLatch.await();
        Assert.assertNull((Object)failMsg[0]);
        cache.config().setLoader(oldLoader);
    }

    static class A
    implements Serializable {
        private static final long serialVersionUID = 1692575072446353143L;
        int id;
        String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ((A)obj).id == this.id;
        }
    }
}

