/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.examples;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.MultiLevelCacheBuilder;
import com.alicp.jetcache.embedded.CaffeineCacheBuilder;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultCacheMonitorManager;
import com.alicp.jetcache.support.FastjsonKeyConvertor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class CacheMonitorWithMultiLevelCacheExample {
    public static void main(String[] args) throws Exception {
        DefaultCacheMonitor l1CacheMonitor = new DefaultCacheMonitor("OrderCache_L1");
        DefaultCacheMonitor l2CacheMonitor = new DefaultCacheMonitor("OrderCache_L2");
        DefaultCacheMonitor orderCacheMonitor = new DefaultCacheMonitor("OrderCache");
        Cache l1Cache = ((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)CaffeineCacheBuilder.createCaffeineCacheBuilder().limit(100)).expireAfterWrite(200L, TimeUnit.SECONDS)).keyConvertor((Function)FastjsonKeyConvertor.INSTANCE)).addMonitor((CacheMonitor)l1CacheMonitor)).buildCache();
        Cache l2Cache = ((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)((CaffeineCacheBuilder.CaffeineCacheBuilderImpl)CaffeineCacheBuilder.createCaffeineCacheBuilder().limit(100)).expireAfterWrite(200L, TimeUnit.SECONDS)).keyConvertor((Function)FastjsonKeyConvertor.INSTANCE)).addMonitor((CacheMonitor)l2CacheMonitor)).buildCache();
        Cache orderCache = ((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)MultiLevelCacheBuilder.createMultiLevelCacheBuilder().addCache(new Cache[]{l1Cache, l2Cache})).addMonitor((CacheMonitor)orderCacheMonitor)).buildCache();
        boolean verboseLog = true;
        DefaultCacheMonitorManager statLogger = new DefaultCacheMonitorManager(1, TimeUnit.SECONDS, verboseLog);
        statLogger.add(new DefaultCacheMonitor[]{l1CacheMonitor, l2CacheMonitor, orderCacheMonitor});
        statLogger.start();
        Thread t = new Thread(() -> {
            for (int i = 0; i < 100; ++i) {
                orderCache.put((Object)"20161111", (Object)123456789);
                orderCache.get((Object)"20161111");
                orderCache.get((Object)"20161212");
                orderCache.remove((Object)"20161111");
                orderCache.remove((Object)"20161212");
                orderCache.computeIfAbsent((Object)"20161111", k -> 100000);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        t.join();
        statLogger.stop();
    }
}

