/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.test.spring;

import com.alicp.jetcache.test.beans.FactoryBeanTarget;
import com.alicp.jetcache.test.beans.Service;
import com.alicp.jetcache.test.beans.TestBean;
import com.alicp.jetcache.test.support.DynamicQuery;
import com.alicp.jetcache.test.support.DynamicQueryWithEquals;
import org.junit.Assert;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringTest
implements ApplicationContextAware {
    protected ApplicationContext context;

    protected void doTest() throws Exception {
        Service service = (Service)this.context.getBean("service");
        TestBean bean = (TestBean)this.context.getBean("testBean");
        this.testService(service, bean);
        this.testTestBean(bean);
        FactoryBeanTarget target = (FactoryBeanTarget)this.context.getBean("factoryBeanTarget");
        Assert.assertEquals((long)target.count(), (long)target.count());
    }

    private void testService(Service service, TestBean bean) throws Exception {
        Assert.assertNotEquals((long)service.notCachedCount(), (long)service.notCachedCount());
        Assert.assertEquals((long)service.countWithAnnoOnClass(), (long)service.countWithAnnoOnClass());
        Assert.assertEquals((long)service.countWithAnnoOnInterface(), (long)service.countWithAnnoOnInterface());
        Assert.assertNotEquals((long)service.enableCacheWithNoCacheCount(bean), (long)service.enableCacheWithNoCacheCount(bean));
        Assert.assertEquals((long)service.enableCacheWithAnnoOnClass(bean), (long)service.enableCacheWithAnnoOnClass(bean));
        Assert.assertEquals((long)service.enableCacheWithAnnoOnInterface(bean), (long)service.enableCacheWithAnnoOnInterface(bean));
    }

    private void testTestBean(TestBean bean) throws Exception {
        Assert.assertNotEquals((long)bean.noCacheCount(), (long)bean.noCacheCount());
        Assert.assertEquals((long)bean.staticCount(), (long)bean.staticCount());
        Assert.assertEquals((long)bean.count(), (long)bean.count());
        Assert.assertEquals((long)bean.countWithLocalCache(), (long)bean.countWithLocalCache());
        Assert.assertEquals((long)bean.countWithBoth(), (long)bean.countWithBoth());
        Assert.assertNotEquals((long)bean.countWithDisabledCache(), (long)bean.countWithDisabledCache());
        int x = bean.countWithExpire50();
        Assert.assertEquals((long)x, (long)bean.countWithExpire50());
        Thread.sleep(50L);
        Assert.assertNotEquals((long)x, (long)bean.countWithExpire50());
        DynamicQuery q1 = new DynamicQuery();
        q1.setId(1000L);
        q1.setName("N1");
        DynamicQuery q2 = new DynamicQuery();
        q2.setId(1000L);
        q2.setName("N2");
        DynamicQuery q3 = new DynamicQuery();
        q3.setId(1000L);
        q3.setName("N1");
        int x1 = bean.countLocalWithDynamicQuery(q1);
        int x2 = bean.countLocalWithDynamicQuery(q2);
        int x3 = bean.countLocalWithDynamicQuery(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        x1 = bean.countRemoteWithDynamicQuery(q1);
        x2 = bean.countRemoteWithDynamicQuery(q2);
        x3 = bean.countRemoteWithDynamicQuery(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        x1 = bean.countLocalWithDynamicQueryAndKeyConvertor(q1);
        x2 = bean.countLocalWithDynamicQueryAndKeyConvertor(q2);
        x3 = bean.countLocalWithDynamicQueryAndKeyConvertor(q3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        DynamicQueryWithEquals dqwe1 = new DynamicQueryWithEquals();
        dqwe1.setId(1000L);
        dqwe1.setName("N1");
        DynamicQueryWithEquals dqwe2 = new DynamicQueryWithEquals();
        dqwe2.setId(1001L);
        dqwe2.setName("N2");
        DynamicQueryWithEquals dqwe3 = new DynamicQueryWithEquals();
        dqwe3.setId(1000L);
        dqwe3.setName("N1");
        x1 = bean.countLocalWithDynamicQueryWithEquals(dqwe1);
        x2 = bean.countLocalWithDynamicQueryWithEquals(dqwe2);
        x3 = bean.countLocalWithDynamicQueryWithEquals(dqwe3);
        Assert.assertNotEquals((long)x1, (long)x2);
        Assert.assertEquals((long)x1, (long)x3);
        Assert.assertEquals((long)bean.countEnabledWithConfigBean(), (long)bean.countEnabledWithConfigBean());
        Assert.assertNotEquals((long)bean.countDisabledWithConfigBean(), (long)bean.countDisabledWithConfigBean());
        Assert.assertNotEquals((long)bean.countWithWrongCondition(), (long)bean.countWithWrongCondition());
        Assert.assertEquals((long)bean.count(true), (long)bean.count(true));
        Assert.assertNotEquals((long)bean.count(false), (long)bean.count(false));
        Assert.assertNotEquals((long)bean.count(), (long)bean.count1());
        Assert.assertEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount1_WithNameN1());
        Assert.assertEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount2_WithNameN1());
        Assert.assertNotEquals((long)bean.namedCount1_WithNameN1(), (long)bean.namedCount_WithNameN2());
        Assert.assertEquals((long)bean.namedCount_WithNameN2(), (long)bean.namedCount_WithNameN2());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

