/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redisson;

import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.redisson.RedissonCacheConfig;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.support.CacheMessage;
import com.alicp.jetcache.support.SquashedLogger;
import java.util.Objects;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonBroadcastManager
extends BroadcastManager {
    private static final Logger logger = LoggerFactory.getLogger(RedissonBroadcastManager.class);
    private final RedissonCacheConfig<?, ?> config;
    private final String channel;
    private final RedissonClient client;
    private volatile int subscribeId;

    public RedissonBroadcastManager(CacheManager cacheManager, RedissonCacheConfig<?, ?> config) {
        super(cacheManager);
        this.checkConfig(config);
        this.config = config;
        this.channel = config.getBroadcastChannel();
        this.client = config.getRedissonClient();
    }

    public synchronized void startSubscribe() {
        if (this.subscribeId == 0 && Objects.nonNull(this.channel) && !this.channel.isEmpty()) {
            this.subscribeId = this.client.getTopic(this.channel).addListener(byte[].class, (channel, msg) -> this.processNotification((byte[])msg, this.config.getValueDecoder()));
        }
    }

    public synchronized void close() {
        int id = this.subscribeId;
        if (id > 0 && Objects.nonNull(this.channel)) {
            this.subscribeId = 0;
            try {
                this.client.getTopic(this.channel).removeListener(new Integer[]{id});
            }
            catch (Throwable e) {
                logger.warn("unsubscribe {} fail", (Object)this.channel, (Object)e);
            }
        }
    }

    public CacheResult publish(CacheMessage cacheMessage) {
        try {
            if (Objects.nonNull(this.channel) && Objects.nonNull(cacheMessage)) {
                byte[] msg = (byte[])this.config.getValueEncoder().apply(cacheMessage);
                this.client.getTopic(this.channel).publish((Object)msg);
                return CacheResult.SUCCESS_WITHOUT_MSG;
            }
            return CacheResult.FAIL_WITHOUT_MSG;
        }
        catch (Throwable e) {
            SquashedLogger.getLogger((Logger)logger).error((CharSequence)"jetcache publish error", e);
            return new CacheResult(e);
        }
    }
}

