/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.redisson;

import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.redisson.RedissonCacheConfig;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;

public class RedissonCache<K, V>
extends AbstractExternalCache<K, V> {
    private final RedissonClient client;
    private final RedissonCacheConfig<K, V> config;

    public RedissonCache(RedissonCacheConfig<K, V> config) {
        super(config);
        this.config = config;
        this.client = config.getRedissonClient();
    }

    protected String getCacheKey(K key) {
        byte[] newKey = this.buildKey(key);
        return new String(newKey, StandardCharsets.UTF_8);
    }

    public CacheConfig<K, V> config() {
        return this.config;
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("RedissonCache does not support unwrap");
    }

    protected CacheGetResult<V> do_GET(K key) {
        try {
            RBucket rb = this.client.getBucket(this.getCacheKey(key));
            CacheValueHolder holder = (CacheValueHolder)rb.get();
            if (Objects.nonNull(holder)) {
                long now = System.currentTimeMillis();
                long expire = holder.getExpireTime();
                if (expire > 0L && now >= expire) {
                    return CacheGetResult.EXPIRED_WITHOUT_MSG;
                }
                return new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
            }
            return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("GET", key, e);
            return new CacheGetResult(e);
        }
    }

    protected MultiGetResult<K, V> do_GET_ALL(Set<? extends K> keys) {
        try {
            HashMap<K, CacheGetResult> retMap = new HashMap<K, CacheGetResult>(16);
            if (Objects.nonNull(keys) && !keys.isEmpty()) {
                HashMap<K, String> keyMap = new HashMap<K, String>(keys.size());
                for (K k : keys) {
                    String key;
                    if (!Objects.nonNull(k) || !Objects.nonNull(key = this.getCacheKey(k))) continue;
                    keyMap.put(k, key);
                }
                if (!keyMap.isEmpty()) {
                    Map kvMap = this.client.getBuckets().get(keyMap.values().toArray(new String[0]));
                    long now = System.currentTimeMillis();
                    for (K k : keys) {
                        CacheValueHolder holder;
                        String key = (String)keyMap.get(k);
                        if (Objects.nonNull(key) && Objects.nonNull(kvMap) && Objects.nonNull(holder = (CacheValueHolder)kvMap.get(key))) {
                            long expire = holder.getExpireTime();
                            CacheGetResult ret = expire > 0L && now >= expire ? CacheGetResult.EXPIRED_WITHOUT_MSG : new CacheGetResult(CacheResultCode.SUCCESS, null, holder);
                            retMap.put(k, ret);
                            continue;
                        }
                        retMap.put(k, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
                    }
                }
            }
            return new MultiGetResult(CacheResultCode.SUCCESS, null, retMap);
        }
        catch (Throwable e) {
            this.logError("GET_ALL", "keys(" + (Objects.nonNull(keys) ? keys.size() : 0) + ")", e);
            return new MultiGetResult(e);
        }
    }

    protected CacheResult do_PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            this.client.getBucket(this.getCacheKey(key)).set((Object)holder, expireAfterWrite, timeUnit);
            return CacheGetResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT", key, e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            if (Objects.nonNull(map) && !map.isEmpty()) {
                long expire = timeUnit.toMillis(expireAfterWrite);
                RBatch batch = this.client.createBatch();
                map.forEach((k, v) -> {
                    CacheValueHolder holder = new CacheValueHolder(v, expire);
                    batch.getBucket(this.getCacheKey(k)).setAsync((Object)holder, expireAfterWrite, timeUnit);
                });
                batch.execute();
            }
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT_ALL", "map(" + map.size() + ")", e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_REMOVE(K key) {
        try {
            boolean ret = this.client.getBucket(this.getCacheKey(key)).delete();
            return ret ? CacheResult.SUCCESS_WITHOUT_MSG : CacheResult.FAIL_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("REMOVE", key, e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_REMOVE_ALL(Set<? extends K> keys) {
        try {
            if (Objects.nonNull(keys) && !keys.isEmpty()) {
                RBatch batch = this.client.createBatch();
                keys.forEach(key -> batch.getBucket(this.getCacheKey(key)).deleteAsync());
                batch.execute();
            }
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("REMOVE_ALL", "keys(" + keys.size() + ")", e);
            return new CacheResult(e);
        }
    }

    protected CacheResult do_PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        try {
            CacheValueHolder holder = new CacheValueHolder(value, timeUnit.toMillis(expireAfterWrite));
            boolean success = this.client.getBucket(this.getCacheKey(key)).trySet((Object)holder, expireAfterWrite, timeUnit);
            return success ? CacheResult.SUCCESS_WITHOUT_MSG : CacheResult.EXISTS_WITHOUT_MSG;
        }
        catch (Throwable e) {
            this.logError("PUT_IF_ABSENT", key, e);
            return new CacheResult(e);
        }
    }
}

