/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.alicp.jetcache.support.ObjectPool;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;

public class KryoValueEncoder
extends AbstractValueEncoder {
    public static final KryoValueEncoder INSTANCE = new KryoValueEncoder(true);
    private static final int INIT_BUFFER_SIZE = 2048;
    static ObjectPool<KryoCache> kryoCacheObjectPool = new ObjectPool<KryoCache>(16, new ObjectPool.ObjectFactory<KryoCache>(){

        @Override
        public KryoCache create() {
            return new KryoCache();
        }

        @Override
        public void reset(KryoCache obj) {
            obj.getKryo().reset();
            obj.getOutput().clear();
        }
    });

    public KryoValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    @Override
    public byte[] apply(Object value) {
        KryoCache kryoCache = null;
        try {
            kryoCache = kryoCacheObjectPool.borrowObject();
            Output output = kryoCache.getOutput();
            if (this.useIdentityNumber) {
                this.writeInt(output, 1251293826);
            }
            kryoCache.getKryo().writeClassAndObject(output, value);
            byte[] byArray = output.toBytes();
            return byArray;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Kryo Encode error. ");
            sb.append("msg=").append(e.getMessage());
            throw new CacheEncodeException(sb.toString(), e);
        }
        finally {
            if (kryoCache != null) {
                kryoCacheObjectPool.returnObject(kryoCache);
            }
        }
    }

    private void writeInt(Output output, int value) {
        output.writeByte(value >>> 24);
        output.writeByte(value >>> 16);
        output.writeByte(value >>> 8);
        output.writeByte(value);
    }

    public static class KryoCache {
        final Output output;
        final Kryo kryo = new Kryo();

        public KryoCache() {
            this.kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
            byte[] buffer = new byte[2048];
            this.output = new Output(buffer, -1);
        }

        public Output getOutput() {
            return this.output;
        }

        public Kryo getKryo() {
            return this.kryo;
        }
    }
}

