/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPool<T> {
    private final ArrayBlockingQueue<T> queue;
    private final int size;
    private final ObjectFactory<T> factory;
    private static final Logger logger = LoggerFactory.getLogger(ObjectPool.class);

    public ObjectPool(int size, ObjectFactory<T> factory) {
        this.size = size;
        this.factory = factory;
        this.queue = new ArrayBlockingQueue(size);
        for (int i = 0; i < size; ++i) {
            this.queue.add(factory.create());
        }
        logger.debug("Init the object pool with size {}", (Object)size);
    }

    public T borrowObject() {
        T t = this.queue.poll();
        if (t == null) {
            logger.debug("The pool is not enough, create a new object");
            return this.factory.create();
        }
        return t;
    }

    public void returnObject(T obj) {
        if (obj == null) {
            return;
        }
        this.factory.reset(obj);
        this.queue.offer(obj);
    }

    public static interface ObjectFactory<T> {
        public T create();

        public void reset(T var1);
    }
}

