/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.embedded.LinkedHashMapCache;
import com.alicp.jetcache.support.JetCacheExecutor;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class Cleaner {
    static ConcurrentLinkedQueue<WeakReference<LinkedHashMapCache>> linkedHashMapCaches = new ConcurrentLinkedQueue();

    Cleaner() {
    }

    static void add(LinkedHashMapCache cache) {
        linkedHashMapCaches.add(new WeakReference<LinkedHashMapCache>(cache));
    }

    static void run() {
        Iterator<WeakReference<LinkedHashMapCache>> it = linkedHashMapCaches.iterator();
        while (it.hasNext()) {
            WeakReference<LinkedHashMapCache> ref = it.next();
            LinkedHashMapCache c = (LinkedHashMapCache)ref.get();
            if (c == null) {
                it.remove();
                continue;
            }
            c.cleanExpiredEntry();
        }
    }

    static {
        ScheduledExecutorService executorService = JetCacheExecutor.defaultExecutor();
        executorService.scheduleWithFixedDelay(() -> Cleaner.run(), 60L, 60L, TimeUnit.SECONDS);
    }
}

