/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.embedded.Cleaner;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedHashMapCache<K, V>
extends AbstractEmbeddedCache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(LinkedHashMapCache.class);

    public LinkedHashMapCache(EmbeddedCacheConfig<K, V> config) {
        super(config);
        this.addToCleaner();
    }

    protected void addToCleaner() {
        Cleaner.add(this);
    }

    @Override
    protected InnerMap createAreaCache() {
        return new LRUMap(this.config.getLimit());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(LinkedHashMap.class)) {
            return (T)this.innerMap;
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    public void cleanExpiredEntry() {
        ((LRUMap)this.innerMap).cleanExpiredEntry();
    }

    final class LRUMap
    extends LinkedHashMap
    implements InnerMap {
        private final int max;
        private final ReentrantReadWriteLock readWriteLock;

        public LRUMap(int max) {
            super((int)((float)max * 1.4f), 0.75f, true);
            this.readWriteLock = new ReentrantReadWriteLock();
            this.max = max;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanExpiredEntry() {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                Iterator it = this.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry en = it.next();
                    Object value = en.getValue();
                    if (value != null && value instanceof CacheValueHolder) {
                        CacheValueHolder h = (CacheValueHolder)value;
                        if (System.currentTimeMillis() < h.getExpireTime()) continue;
                        it.remove();
                        continue;
                    }
                    if (value == null) {
                        logger.error("key " + en.getKey() + " is null");
                        continue;
                    }
                    logger.error("value of key " + en.getKey() + " is not a CacheValueHolder. type=" + value.getClass());
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(Object key) {
            ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
            lock.lock();
            try {
                Object v = this.get(key);
                return v;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map getAllValues(Collection keys) {
            ReentrantReadWriteLock.ReadLock lock = this.readWriteLock.readLock();
            lock.lock();
            HashMap values = new HashMap();
            try {
                for (Object key : keys) {
                    Object v = this.get(key);
                    if (v == null) continue;
                    values.put(key, v);
                }
            }
            finally {
                lock.unlock();
            }
            return values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putValue(Object key, Object value) {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                this.put(key, value);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAllValues(Map map) {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                Set set = map.entrySet();
                for (Map.Entry en : set) {
                    this.put(en.getKey(), en.getValue());
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeValue(Object key) {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                boolean bl = this.remove(key) != null;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAllValues(Collection keys) {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                for (Object k : keys) {
                    this.remove(k);
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean putIfAbsentValue(Object key, Object value) {
            ReentrantReadWriteLock.WriteLock lock = this.readWriteLock.writeLock();
            lock.lock();
            try {
                CacheValueHolder h = (CacheValueHolder)this.get(key);
                if (h == null || LinkedHashMapCache.this.parseHolderResult(h).getResultCode() == CacheResultCode.EXPIRED) {
                    this.put(key, value);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

