/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.template;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.support.AbstractLifecycle;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultMetricsManager;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.template.CacheMonitorInstaller;
import com.alicp.jetcache.template.QuickConfig;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class MetricsMonitorInstaller
extends AbstractLifecycle
implements CacheMonitorInstaller {
    private final Consumer<StatInfo> metricsCallback;
    private final Duration interval;
    private DefaultMetricsManager metricsManager;

    public MetricsMonitorInstaller(Consumer<StatInfo> metricsCallback, Duration interval) {
        this.metricsCallback = metricsCallback;
        this.interval = interval;
    }

    @Override
    protected void doInit() {
        if (this.metricsCallback != null && this.interval != null) {
            this.metricsManager = new DefaultMetricsManager((int)this.interval.toMinutes(), TimeUnit.MINUTES, this.metricsCallback);
            this.metricsManager.start();
        }
    }

    @Override
    protected void doShutdown() {
        if (this.metricsManager != null) {
            this.metricsManager.stop();
            this.metricsManager.clear();
            this.metricsManager = null;
        }
    }

    @Override
    public void addMonitors(CacheManager cacheManager, Cache cache, QuickConfig quickConfig) {
        MultiLevelCache mc;
        if (this.metricsManager == null) {
            return;
        }
        if ((cache = CacheUtil.getAbstractCache(cache)) instanceof MultiLevelCache && (mc = (MultiLevelCache)cache).caches().length == 2) {
            Cache local = mc.caches()[0];
            Cache remote = mc.caches()[1];
            DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(quickConfig.getName() + "_local");
            local.config().getMonitors().add(localMonitor);
            DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(quickConfig.getName() + "_remote");
            remote.config().getMonitors().add(remoteMonitor);
            this.metricsManager.add(localMonitor, remoteMonitor);
        }
        DefaultCacheMonitor monitor = new DefaultCacheMonitor(quickConfig.getName());
        cache.config().getMonitors().add(monitor);
        this.metricsManager.add(monitor);
    }
}

