/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.MultiLevelCacheBuilder;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.embedded.EmbeddedCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.BroadcastManager;
import com.alicp.jetcache.template.CacheBuilderTemplate;
import com.alicp.jetcache.template.CacheMonitorInstaller;
import com.alicp.jetcache.template.QuickConfig;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCacheManager
implements CacheManager,
AutoCloseable {
    private static final boolean DEFAULT_CACHE_NULL_VALUE = false;
    private static final Logger logger = LoggerFactory.getLogger(SimpleCacheManager.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Cache>> caches = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BroadcastManager> broadcastManagers = new ConcurrentHashMap();
    private CacheBuilderTemplate cacheBuilderTemplate;

    @Override
    @PreDestroy
    public void close() {
        this.broadcastManagers.forEach((area, bm) -> {
            try {
                bm.close();
            }
            catch (Exception e) {
                logger.error("error during close broadcast manager", (Throwable)e);
            }
        });
        this.broadcastManagers.clear();
        this.caches.forEach((area, areaMap) -> areaMap.forEach((cacheName, cache) -> {
            try {
                cache.close();
            }
            catch (Exception e) {
                logger.error("error during close Cache", (Throwable)e);
            }
        }));
        this.caches.clear();
    }

    private ConcurrentHashMap<String, Cache> getCachesByArea(String area) {
        return this.caches.computeIfAbsent(area, key -> new ConcurrentHashMap());
    }

    public Cache getCache(String area, String cacheName) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        return areaMap.get(cacheName);
    }

    @Override
    public void putCache(String area, String cacheName, Cache cache) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        areaMap.put(cacheName, cache);
    }

    @Override
    public BroadcastManager getBroadcastManager(String area) {
        return this.broadcastManagers.get(area);
    }

    @Override
    public void putBroadcastManager(String area, BroadcastManager broadcastManager) {
        this.broadcastManagers.put(area, broadcastManager);
    }

    public CacheBuilderTemplate getCacheBuilderTemplate() {
        return this.cacheBuilderTemplate;
    }

    public void setCacheBuilderTemplate(CacheBuilderTemplate cacheBuilderTemplate) {
        this.cacheBuilderTemplate = cacheBuilderTemplate;
    }

    @Override
    public <K, V> Cache<K, V> getOrCreateCache(QuickConfig config) {
        if (this.cacheBuilderTemplate == null) {
            throw new IllegalStateException("cacheBuilderTemplate not set");
        }
        Objects.requireNonNull(config.getArea());
        Objects.requireNonNull(config.getName());
        ConcurrentHashMap<String, Cache> m = this.getCachesByArea(config.getArea());
        Cache c = m.get(config.getName());
        if (c != null) {
            return c;
        }
        return m.computeIfAbsent(config.getName(), n -> this.create(config));
    }

    private Cache create(QuickConfig config) {
        Cache cache;
        if (config.getCacheType() == null || config.getCacheType() == CacheType.REMOTE) {
            cache = this.buildRemote(config);
        } else if (config.getCacheType() == CacheType.LOCAL) {
            cache = this.buildLocal(config);
        } else {
            Cache local = this.buildLocal(config);
            Cache remote = this.buildRemote(config);
            boolean useExpireOfSubCache = config.getLocalExpire() != null;
            cache = ((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)MultiLevelCacheBuilder.createMultiLevelCacheBuilder().expireAfterWrite(remote.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS)).addCache(local, remote)).useExpireOfSubCache(useExpireOfSubCache)).cacheNullValue(config.getCacheNullValue() != null ? config.getCacheNullValue() : false)).buildCache();
        }
        if (config.getRefreshPolicy() != null) {
            cache = new RefreshCache(cache);
        } else if (config.getLoader() != null) {
            cache = new LoadingCache(cache);
        }
        cache.config().setRefreshPolicy(config.getRefreshPolicy());
        boolean protect = config.getPenetrationProtect() != null ? config.getPenetrationProtect().booleanValue() : this.cacheBuilderTemplate.isPenetrationProtect();
        cache.config().setCachePenetrationProtect(protect);
        cache.config().setPenetrationProtectTimeout(config.getPenetrationProtectTimeout());
        for (CacheMonitorInstaller i : this.cacheBuilderTemplate.getCacheMonitorInstallers()) {
            i.addMonitors(this, cache, config);
        }
        return cache;
    }

    private Cache buildRemote(QuickConfig config) {
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.cacheBuilderTemplate.getCacheBuilder(1, config.getArea());
        if (cacheBuilder == null) {
            throw new CacheConfigException("no remote cache builder: " + config.getArea());
        }
        if (config.getExpire() != null && config.getExpire().toMillis() > 0L) {
            cacheBuilder.expireAfterWrite(config.getExpire().toMillis(), TimeUnit.MILLISECONDS);
        }
        String prefix = config.getUseAreaInPrefix() != null && config.getUseAreaInPrefix() != false ? config.getArea() + "_" + config.getName() : config.getName();
        if (cacheBuilder.getConfig().getKeyPrefixSupplier() != null) {
            Supplier<String> supplier = cacheBuilder.getConfig().getKeyPrefixSupplier();
            cacheBuilder.setKeyPrefixSupplier(() -> (String)supplier.get() + prefix);
        } else {
            cacheBuilder.setKeyPrefix(prefix);
        }
        if (config.getKeyConvertor() != null) {
            cacheBuilder.getConfig().setKeyConvertor(config.getKeyConvertor());
        }
        if (config.getValueEncoder() != null) {
            cacheBuilder.getConfig().setValueEncoder(config.getValueEncoder());
        }
        if (config.getValueDecoder() != null) {
            cacheBuilder.getConfig().setValueDecoder(config.getValueDecoder());
        }
        cacheBuilder.setCacheNullValue(config.getCacheNullValue() != null ? config.getCacheNullValue() : false);
        return cacheBuilder.buildCache();
    }

    private Cache buildLocal(QuickConfig config) {
        EmbeddedCacheBuilder cacheBuilder = (EmbeddedCacheBuilder)this.cacheBuilderTemplate.getCacheBuilder(0, config.getArea());
        if (cacheBuilder == null) {
            throw new CacheConfigException("no local cache builder: " + config.getArea());
        }
        if (config.getLocalLimit() != null && config.getLocalLimit() > 0) {
            cacheBuilder.setLimit(config.getLocalLimit());
        }
        if (config.getCacheType() == CacheType.BOTH && config.getLocalExpire() != null && config.getLocalExpire().toMillis() > 0L) {
            cacheBuilder.expireAfterWrite(config.getLocalExpire().toMillis(), TimeUnit.MILLISECONDS);
        } else if (config.getExpire() != null && config.getExpire().toMillis() > 0L) {
            cacheBuilder.expireAfterWrite(config.getExpire().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (config.getKeyConvertor() != null) {
            cacheBuilder.getConfig().setKeyConvertor(config.getKeyConvertor());
        }
        cacheBuilder.setCacheNullValue(config.getCacheNullValue() != null ? config.getCacheNullValue() : false);
        return cacheBuilder.buildCache();
    }
}

