/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheInvokeException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@FunctionalInterface
public interface CacheLoader<K, V>
extends Function<K, V> {
    public V load(K var1) throws Throwable;

    default public Map<K, V> loadAll(Set<K> keys) throws Throwable {
        HashMap<K, V> map = new HashMap<K, V>();
        for (K k : keys) {
            map.put(k, this.load(k));
        }
        return map;
    }

    @Override
    default public V apply(K key) {
        try {
            return this.load(key);
        }
        catch (Throwable e) {
            throw new CacheInvokeException(e.getMessage(), e);
        }
    }

    default public boolean vetoCacheUpdate() {
        return false;
    }
}

