/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.serializers.CompatibleFieldSerializer;
import java.lang.ref.WeakReference;

public class Kryo5ValueEncoder
extends AbstractValueEncoder {
    public static final Kryo5ValueEncoder INSTANCE = new Kryo5ValueEncoder(true);
    private static int INIT_BUFFER_SIZE = 256;
    static ThreadLocal<Object[]> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        kryo.setRegistrationRequired(false);
        Output output = new Output(INIT_BUFFER_SIZE, -1);
        WeakReference<Output> ref = new WeakReference<Output>(output);
        return new Object[]{kryo, ref};
    });

    public Kryo5ValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(Object value) {
        byte[] byArray;
        Object[] kryoAndBuffer = kryoThreadLocal.get();
        Kryo kryo = (Kryo)kryoAndBuffer[0];
        WeakReference<Output> ref = (WeakReference<Output>)kryoAndBuffer[1];
        Output output = (Output)ref.get();
        if (output == null) {
            output = new Output(INIT_BUFFER_SIZE, -1);
        }
        try {
            if (this.useIdentityNumber) {
                this.writeInt(output, -153049664);
            }
            kryo.reset();
            kryo.writeClassAndObject(output, value);
            byArray = output.toBytes();
        }
        catch (Throwable throwable) {
            try {
                output.reset();
                if (ref.get() == null) {
                    kryoAndBuffer[1] = ref = new WeakReference<Output>(output);
                }
                throw throwable;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder("Kryo Encode error. ");
                sb.append("msg=").append(e.getMessage());
                throw new CacheEncodeException(sb.toString(), e);
            }
        }
        output.reset();
        if (ref.get() == null) {
            kryoAndBuffer[1] = ref = new WeakReference<Output>(output);
        }
        return byArray;
    }

    private void writeInt(Output output, int value) {
        output.writeByte(value >>> 24);
        output.writeByte(value >>> 16);
        output.writeByte(value >>> 8);
        output.writeByte(value);
    }
}

