/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheManager;
import com.alicp.jetcache.support.BroadcastManager;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCacheManager
implements CacheManager,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCacheManager.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Cache>> caches = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BroadcastManager> broadcastManagers = new ConcurrentHashMap();
    static final SimpleCacheManager defaultManager = new SimpleCacheManager();

    @Override
    public void close() {
        this.broadcastManagers.forEach((area, bm) -> {
            try {
                bm.close();
            }
            catch (Exception e) {
                logger.error("error during close broadcast manager", (Throwable)e);
            }
        });
        this.broadcastManagers.clear();
        this.caches.forEach((area, areaMap) -> areaMap.forEach((cacheName, cache) -> {
            try {
                cache.close();
            }
            catch (Exception e) {
                logger.error("error during close Cache", (Throwable)e);
            }
        }));
        this.caches.clear();
    }

    private ConcurrentHashMap<String, Cache> getCachesByArea(String area) {
        return this.caches.computeIfAbsent(area, key -> new ConcurrentHashMap());
    }

    @Override
    public Cache getCache(String area, String cacheName) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        return areaMap.get(cacheName);
    }

    @Override
    public void putCache(String area, String cacheName, Cache cache) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        areaMap.put(cacheName, cache);
    }

    @Override
    public BroadcastManager getBroadcastManager(String area) {
        return this.broadcastManagers.get(area);
    }

    @Override
    public void putBroadcastManager(String area, BroadcastManager broadcastManager) {
        this.broadcastManagers.put(area, broadcastManager);
    }
}

