/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueDecoder;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.JavaValueEncoder;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.KryoValueEncoder;
import com.alicp.jetcache.support.SpringJavaValueDecoder;
import java.util.HashMap;
import java.util.Map;

public class DecoderMap {
    private static Map<Integer, AbstractValueDecoder> decoderMap = new HashMap<Integer, AbstractValueDecoder>();
    private static boolean inited = false;

    public static AbstractValueDecoder getDecoder(int identityNumber) {
        return decoderMap.get(identityNumber);
    }

    public static synchronized void register(int identityNumber, AbstractValueDecoder decoder) {
        HashMap<Integer, AbstractValueDecoder> newMap = new HashMap<Integer, AbstractValueDecoder>();
        newMap.putAll(decoderMap);
        newMap.put(identityNumber, decoder);
        decoderMap = newMap;
    }

    static void registerBuildInDecoder() {
        if (!inited) {
            DecoderMap.register(JavaValueEncoder.IDENTITY_NUMBER, DecoderMap.defaultJavaValueDecoder());
            DecoderMap.register(KryoValueEncoder.IDENTITY_NUMBER, KryoValueDecoder.INSTANCE);
            inited = true;
        }
    }

    public static JavaValueDecoder defaultJavaValueDecoder() {
        try {
            Class.forName("org.springframework.core.ConfigurableObjectInputStream");
            return SpringJavaValueDecoder.INSTANCE;
        }
        catch (ClassNotFoundException e) {
            return JavaValueDecoder.INSTANCE;
        }
    }
}

