/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.MultiGetResult;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Cache<K, V>
extends Closeable {
    public static final Logger logger = LoggerFactory.getLogger(Cache.class);

    default public V get(K key) throws CacheInvokeException {
        CacheGetResult<V> result = this.GET(key);
        if (result.isSuccess()) {
            return result.getValue();
        }
        return null;
    }

    default public Map<K, V> getAll(Set<? extends K> keys) throws CacheInvokeException {
        MultiGetResult<K, V> cacheGetResults = this.GET_ALL(keys);
        return cacheGetResults.unwrapValues();
    }

    default public void put(K key, V value) {
        this.PUT(key, value);
    }

    default public void putAll(Map<? extends K, ? extends V> map) {
        this.PUT_ALL(map);
    }

    default public boolean putIfAbsent(K key, V value) {
        CacheResult result = this.PUT_IF_ABSENT(key, value, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
        return result.getResultCode() == CacheResultCode.SUCCESS;
    }

    default public boolean remove(K key) {
        return this.REMOVE(key).isSuccess();
    }

    default public void removeAll(Set<? extends K> keys) {
        this.REMOVE_ALL(keys);
    }

    public <T> T unwrap(Class<T> var1);

    @Override
    default public void close() {
    }

    public CacheConfig<K, V> config();

    default public AutoReleaseLock tryLock(K key, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return null;
        }
        String uuid = UUID.randomUUID().toString();
        long expireTimestamp = System.currentTimeMillis() + timeUnit.toMillis(expire);
        CacheConfig<K, V> config = this.config();
        AutoReleaseLock lock = () -> {
            int unlockCount = 0;
            while (unlockCount++ < config.getTryLockUnlockCount()) {
                if (System.currentTimeMillis() < expireTimestamp) {
                    CacheResult unlockResult = this.REMOVE(key);
                    if (unlockResult.getResultCode() == CacheResultCode.FAIL || unlockResult.getResultCode() == CacheResultCode.PART_SUCCESS) {
                        logger.info("[tryLock] [{} of {}] [{}] unlock failed. Key={}, msg = {}", new Object[]{unlockCount, config.getTryLockUnlockCount(), uuid, key, unlockResult.getMessage()});
                        continue;
                    }
                    if (unlockResult.isSuccess()) {
                        logger.debug("[tryLock] [{} of {}] [{}] successfully release the lock. Key={}", new Object[]{unlockCount, config.getTryLockUnlockCount(), uuid, key});
                        return;
                    }
                    logger.warn("[tryLock] [{} of {}] [{}] unexpected unlock result: Key={}, result={}", new Object[]{unlockCount, config.getTryLockUnlockCount(), uuid, key, unlockResult.getResultCode()});
                    return;
                }
                logger.info("[tryLock] [{} of {}] [{}] lock already expired: Key={}", new Object[]{unlockCount, config.getTryLockUnlockCount(), uuid, key});
                return;
            }
        };
        int lockCount = 0;
        Cache cache = this;
        while (lockCount++ < config.getTryLockLockCount()) {
            CacheResult lockResult = cache.PUT_IF_ABSENT(key, uuid, expire, timeUnit);
            if (lockResult.isSuccess()) {
                logger.debug("[tryLock] [{} of {}] [{}] successfully get a lock. Key={}", new Object[]{lockCount, config.getTryLockLockCount(), uuid, key});
                return lock;
            }
            if (lockResult.getResultCode() == CacheResultCode.FAIL || lockResult.getResultCode() == CacheResultCode.PART_SUCCESS) {
                logger.info("[tryLock] [{} of {}] [{}] cache access failed during get lock, will inquiry {} times. Key={}, msg={}", new Object[]{lockCount, config.getTryLockLockCount(), uuid, config.getTryLockInquiryCount(), key, lockResult.getMessage()});
                int inquiryCount = 0;
                while (inquiryCount++ < config.getTryLockInquiryCount()) {
                    CacheGetResult<V> inquiryResult = cache.GET(key);
                    if (inquiryResult.isSuccess()) {
                        if (uuid.equals(inquiryResult.getValue())) {
                            logger.debug("[tryLock] [{} of {}] [{}] successfully get a lock after inquiry. Key={}", new Object[]{inquiryCount, config.getTryLockInquiryCount(), uuid, key});
                            return lock;
                        }
                        logger.debug("[tryLock] [{} of {}] [{}] not the owner of the lock, return null. Key={}", new Object[]{inquiryCount, config.getTryLockInquiryCount(), uuid, key});
                        return null;
                    }
                    logger.info("[tryLock] [{} of {}] [{}] inquiry failed. Key={}, msg={}", new Object[]{inquiryCount, config.getTryLockInquiryCount(), uuid, key, inquiryResult.getMessage()});
                }
                continue;
            }
            logger.debug("[tryLock] [{} of {}] [{}] others holds the lock, return null. Key={}", new Object[]{lockCount, config.getTryLockLockCount(), uuid, key});
            return null;
        }
        logger.debug("[tryLock] [{}] return null after {} attempts. Key={}", new Object[]{uuid, config.getTryLockLockCount(), key});
        return null;
    }

    default public boolean tryLockAndRun(K key, long expire, TimeUnit timeUnit, Runnable action) {
        try (AutoReleaseLock lock = this.tryLock(key, expire, timeUnit);){
            if (lock != null) {
                action.run();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public CacheGetResult<V> GET(K var1);

    public MultiGetResult<K, V> GET_ALL(Set<? extends K> var1);

    default public V computeIfAbsent(K key, Function<K, V> loader) {
        return this.computeIfAbsent(key, loader, this.config().isCacheNullValue());
    }

    public V computeIfAbsent(K var1, Function<K, V> var2, boolean var3);

    public V computeIfAbsent(K var1, Function<K, V> var2, boolean var3, long var4, TimeUnit var6);

    default public void put(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        this.PUT(key, value, expireAfterWrite, timeUnit);
    }

    default public CacheResult PUT(K key, V value) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT(key, value, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    public CacheResult PUT(K var1, V var2, long var3, TimeUnit var5);

    default public void putAll(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        this.PUT_ALL(map, expireAfterWrite, timeUnit);
    }

    default public CacheResult PUT_ALL(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT_ALL(map, this.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS);
    }

    public CacheResult PUT_ALL(Map<? extends K, ? extends V> var1, long var2, TimeUnit var4);

    public CacheResult REMOVE(K var1);

    public CacheResult REMOVE_ALL(Set<? extends K> var1);

    public CacheResult PUT_IF_ABSENT(K var1, V var2, long var3, TimeUnit var5);
}

