/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.ResultData;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class MultiGetResult<K, V>
extends CacheResult {
    private Map<K, CacheGetResult<V>> values;

    public MultiGetResult(CompletionStage<ResultData> future) {
        super(future);
    }

    public MultiGetResult(CacheResultCode resultCode, String message, Map<K, CacheGetResult<V>> values) {
        super(CompletableFuture.completedFuture(new ResultData(resultCode, message, values)));
    }

    public MultiGetResult(Throwable e) {
        super(e);
    }

    public Map<K, CacheGetResult<V>> getValues() {
        this.waitForResult();
        return this.values;
    }

    @Override
    protected void fetchResultSuccess(ResultData resultData) {
        super.fetchResultSuccess(resultData);
        this.values = (Map)resultData.getOriginData();
    }

    @Override
    protected void fetchResultFail(Throwable e) {
        super.fetchResultFail(e);
        this.values = null;
    }

    public Map<K, V> unwrapValues() {
        this.waitForResult();
        if (this.values == null) {
            return null;
        }
        HashMap m = new HashMap();
        this.values.entrySet().stream().forEach(en -> {
            if (((CacheGetResult)en.getValue()).isSuccess()) {
                m.put(en.getKey(), ((CacheGetResult)en.getValue()).getValue());
            }
        });
        return m;
    }
}

