/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.SimpleProxyCache;
import com.alicp.jetcache.event.CacheEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class LoadingCache<K, V>
extends SimpleProxyCache<K, V> {
    protected Consumer<CacheEvent> eventConsumer;
    protected CacheConfig<K, V> config = this.config();

    public LoadingCache(Cache<K, V> cache) {
        super(cache);
        this.eventConsumer = CacheUtil.getAbstractCache(cache)::notify;
    }

    @Override
    public V get(K key) throws CacheInvokeException {
        CacheLoader<K, V> loader = this.config.getLoader();
        if (loader != null) {
            return AbstractCache.computeIfAbsentImpl(key, loader, this.config.isCacheNullValue(), 0L, null, this);
        }
        return this.cache.get(key);
    }

    protected boolean needUpdate(V loadedValue, CacheLoader<K, V> loader) {
        if (loadedValue == null && !this.config.isCacheNullValue()) {
            return false;
        }
        return !loader.vetoCacheUpdate();
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws CacheInvokeException {
        CacheLoader loader = this.config.getLoader();
        if (loader != null) {
            MultiGetResult r = this.GET_ALL(keys);
            Map<Object, Object> kvMap = r.isSuccess() || r.getResultCode() == CacheResultCode.PART_SUCCESS ? r.unwrapValues() : new HashMap();
            HashSet keysNeedLoad = new HashSet();
            keys.forEach(k -> {
                if (!kvMap.containsKey(k)) {
                    keysNeedLoad.add(k);
                }
            });
            if (!this.config.isCachePenetrationProtect()) {
                Map<K, V> loadResult;
                if (this.eventConsumer != null) {
                    loader = CacheUtil.createProxyLoader(this.cache, loader, this.eventConsumer);
                }
                try {
                    loadResult = loader.loadAll(keysNeedLoad);
                    for (Map.Entry<K, V> en : loadResult.entrySet()) {
                        K key = en.getKey();
                        V loadedValue = en.getValue();
                        if (!this.needUpdate(loadedValue, loader)) continue;
                        this.PUT(key, loadedValue);
                    }
                }
                catch (Throwable e) {
                    throw new CacheInvokeException(e);
                }
                kvMap.putAll(loadResult);
            } else {
                AbstractCache abstractCache = CacheUtil.getAbstractCache(this.cache);
                loader = CacheUtil.createProxyLoader(this.cache, loader, this.eventConsumer);
                for (Object key : keysNeedLoad) {
                    Consumer<Object> cacheUpdater = v -> {
                        if (this.needUpdate(v, this.config.getLoader())) {
                            this.PUT(key, v);
                        }
                    };
                    Object v2 = AbstractCache.synchronizedLoad(abstractCache, key, loader, cacheUpdater, abstractCache.initOrGetLoaderMap());
                    kvMap.put(key, v2);
                }
            }
            return kvMap;
        }
        return this.cache.getAll(keys);
    }
}

