/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheLoadAllEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

class CacheUtil {
    CacheUtil() {
    }

    public static <K, V> CacheLoader<K, V> createProxyLoader(final Cache<K, V> cache, final CacheLoader<K, V> loader, final Consumer<CacheEvent> eventConsumer) {
        return new CacheLoader<K, V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V load(K key) throws Throwable {
                long t = System.currentTimeMillis();
                Object v = null;
                boolean success = false;
                try {
                    v = loader.load(key);
                    success = true;
                }
                finally {
                    t = System.currentTimeMillis() - t;
                    CacheLoadEvent event = new CacheLoadEvent(cache, t, key, v, success);
                    eventConsumer.accept(event);
                }
                return v;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<K, V> loadAll(Set<K> keys) throws Throwable {
                long t = System.currentTimeMillis();
                boolean success = false;
                Map kvMap = null;
                try {
                    kvMap = loader.loadAll(keys);
                    success = true;
                }
                finally {
                    t = System.currentTimeMillis() - t;
                    CacheLoadAllEvent event = new CacheLoadAllEvent(cache, t, keys, kvMap, success);
                    eventConsumer.accept(event);
                }
                return kvMap;
            }

            @Override
            public boolean vetoCacheUpdate() {
                return loader.vetoCacheUpdate();
            }
        };
    }

    public static <K, V> Function<K, V> createProxyLoader(Cache<K, V> cache, Function<K, V> loader, Consumer<CacheEvent> eventConsumer) {
        return k -> {
            long t = System.currentTimeMillis();
            Object v = null;
            boolean success = false;
            try {
                v = loader.apply(k);
                success = true;
            }
            finally {
                t = System.currentTimeMillis() - t;
                CacheLoadEvent event = new CacheLoadEvent(cache, t, k, v, success);
                eventConsumer.accept(event);
            }
            return v;
        };
    }

    public static <K, V> AbstractCache<K, V> getAbstractCache(Cache<K, V> c) {
        while (c instanceof ProxyCache) {
            c = ((ProxyCache)c).getTargetCache();
        }
        return (AbstractCache)c;
    }
}

