/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueEncoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import java.lang.ref.WeakReference;

public class KryoValueEncoder
extends AbstractValueEncoder {
    public static final KryoValueEncoder INSTANCE = new KryoValueEncoder(true);
    protected static int IDENTITY_NUMBER = 1251293826;
    private static int INIT_BUFFER_SIZE = 256;
    static ThreadLocal<Object[]> kryoThreadLocal = ThreadLocal.withInitial(() -> {
        Kryo kryo = new Kryo();
        kryo.setDefaultSerializer(CompatibleFieldSerializer.class);
        Output output = new Output(INIT_BUFFER_SIZE, -1);
        WeakReference<Output> ref = new WeakReference<Output>(output);
        return new Object[]{kryo, ref};
    });

    public KryoValueEncoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(Object value) {
        byte[] byArray;
        Object[] kryoAndOutput = kryoThreadLocal.get();
        Kryo kryo = (Kryo)kryoAndOutput[0];
        WeakReference ref = (WeakReference)kryoAndOutput[1];
        Output output = (Output)ref.get();
        if (output == null) {
            output = new Output(INIT_BUFFER_SIZE, -1);
            kryoAndOutput[1] = new WeakReference<Output>(output);
        }
        if (this.useIdentityNumber) {
            output.writeInt(IDENTITY_NUMBER);
        }
        try {
            kryo.writeClassAndObject(output, value);
            byArray = output.toBytes();
        }
        catch (Throwable throwable) {
            try {
                output.clear();
                throw throwable;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder("Kryo Encode error. ");
                sb.append("msg=").append(e.getMessage());
                throw new CacheEncodeException(sb.toString(), e);
            }
        }
        output.clear();
        return byArray;
    }
}

