/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheGetAllEvent;
import com.alicp.jetcache.event.CacheGetEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.support.FastjsonKeyConvertor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(AbstractCache.class);
    private ConcurrentHashMap<Object, LoaderLock> loaderMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConcurrentHashMap<Object, LoaderLock> initOrGetLoaderMap() {
        if (this.loaderMap == null) {
            AbstractCache abstractCache = this;
            synchronized (abstractCache) {
                if (this.loaderMap == null) {
                    this.loaderMap = new ConcurrentHashMap();
                }
            }
        }
        return this.loaderMap;
    }

    protected void logError(String oper, Object key, Throwable e) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("jetcache(").append(this.getClass().getSimpleName()).append(") ").append(oper).append(" error. key=").append(FastjsonKeyConvertor.INSTANCE.apply(key)).append(".");
        if (this.needLogStackTrace(e)) {
            logger.error(sb.toString(), e);
        } else {
            sb.append(" Exception=").append(e.getClass()).append(", Message:").append(e.getMessage());
            logger.warn(sb.toString());
        }
    }

    protected boolean needLogStackTrace(Throwable e) {
        return true;
    }

    public void notify(CacheEvent e) {
        List<CacheMonitor> monitors = this.config().getMonitors();
        for (CacheMonitor m : monitors) {
            m.afterOperation(e);
        }
    }

    @Override
    public final CacheGetResult<V> GET(K key) {
        long t = System.currentTimeMillis();
        CacheGetResult<V> result = this.do_GET(key);
        result.future().thenRun(() -> {
            CacheGetEvent event = new CacheGetEvent(this, System.currentTimeMillis() - t, key, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheGetResult<V> do_GET(K var1);

    @Override
    public final MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        MultiGetResult<K, V> result = this.do_GET_ALL(keys);
        result.future().thenRun(() -> {
            CacheGetAllEvent event = new CacheGetAllEvent(this, System.currentTimeMillis() - t, keys, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract MultiGetResult<K, V> do_GET_ALL(Set<? extends K> var1);

    @Override
    public final V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, 0L, null, this);
    }

    @Override
    public final V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit) {
        return AbstractCache.computeIfAbsentImpl(key, loader, cacheNullWhenLoaderReturnNull, expireAfterWrite, timeUnit, this);
    }

    static <K, V> V computeIfAbsentImpl(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit, Cache<K, V> cache) {
        Object loadedValue2;
        AbstractCache<K, V> abstractCache = CacheUtil.getAbstractCache(cache);
        Function<K, V> newLoader = CacheUtil.createProxyLoader(cache, loader, abstractCache::notify);
        CacheGetResult<V> r = cache.GET(key);
        if (r.isSuccess()) {
            return r.getValue();
        }
        Consumer<Object> cacheUpdater = loadedValue -> {
            if (loadedValue != null || cacheNullWhenLoaderReturnNull) {
                if (timeUnit != null) {
                    cache.PUT(key, loadedValue, expireAfterWrite, timeUnit);
                } else {
                    cache.put(key, loadedValue);
                }
            }
        };
        if (cache.config().isCachePenetrationProtect()) {
            ConcurrentHashMap<Object, LoaderLock> loaderMap = abstractCache.initOrGetLoaderMap();
            loadedValue2 = AbstractCache.synchronizedLoad(abstractCache, key, newLoader, cacheUpdater, loaderMap);
        } else {
            loadedValue2 = newLoader.apply(key);
            cacheUpdater.accept(loadedValue2);
        }
        return loadedValue2;
    }

    /*
     * Exception decompiling
     */
    static <K, V> V synchronizedLoad(Cache<K, V> abstractCache, K key, Function<K, V> newLoader, Consumer<V> cacheUpdater, ConcurrentHashMap<Object, LoaderLock> loaderMap) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object buildLoaderLockKey(Cache c, Object key) {
        if (c instanceof AbstractEmbeddedCache) {
            return ((AbstractEmbeddedCache)c).buildKey(key);
        }
        if (c instanceof AbstractExternalCache) {
            byte[] bytes = ((AbstractExternalCache)c).buildKey(key);
            return ByteBuffer.wrap(bytes);
        }
        if (c instanceof MultiLevelCache) {
            c = ((MultiLevelCache)c).caches()[0];
            return AbstractCache.buildLoaderLockKey(c, key);
        }
        if (c instanceof ProxyCache) {
            c = ((ProxyCache)c).getTargetCache();
            return AbstractCache.buildLoaderLockKey(c, key);
        }
        throw new CacheException("impossible");
    }

    @Override
    public final CacheResult PUT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.do_PUT(key, value, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutEvent event = new CachePutEvent(this, System.currentTimeMillis() - t, key, value, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT(K var1, V var2, long var3, TimeUnit var5);

    @Override
    public final CacheResult PUT_ALL(Map<? extends K, ? extends V> map, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.do_PUT_ALL(map, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutAllEvent event = new CachePutAllEvent(this, System.currentTimeMillis() - t, map, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT_ALL(Map<? extends K, ? extends V> var1, long var2, TimeUnit var4);

    @Override
    public final CacheResult REMOVE(K key) {
        long t = System.currentTimeMillis();
        CacheResult result = this.do_REMOVE(key);
        result.future().thenRun(() -> {
            CacheRemoveEvent event = new CacheRemoveEvent(this, System.currentTimeMillis() - t, key, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_REMOVE(K var1);

    @Override
    public final CacheResult REMOVE_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        CacheResult result = this.do_REMOVE_ALL(keys);
        result.future().thenRun(() -> {
            CacheRemoveAllEvent event = new CacheRemoveAllEvent(this, System.currentTimeMillis() - t, keys, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_REMOVE_ALL(Set<? extends K> var1);

    @Override
    public final CacheResult PUT_IF_ABSENT(K key, V value, long expireAfterWrite, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.do_PUT_IF_ABSENT(key, value, expireAfterWrite, timeUnit);
        result.future().thenRun(() -> {
            CachePutEvent event = new CachePutEvent(this, System.currentTimeMillis() - t, key, value, result);
            this.notify(event);
        });
        return result;
    }

    protected abstract CacheResult do_PUT_IF_ABSENT(K var1, V var2, long var3, TimeUnit var5);

    private static /* synthetic */ LoaderLock lambda$synchronizedLoad$3(boolean[] create, Object unusedKey) {
        create[0] = true;
        LoaderLock loaderLock = new LoaderLock();
        return loaderLock;
    }

    static class LoaderLock {
        CountDownLatch signal = new CountDownLatch(1);
        boolean success;
        Object value;

        LoaderLock() {
        }
    }
}

