/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.AbstractValueDecoder;
import com.alicp.jetcache.support.CacheEncodeException;
import com.alicp.jetcache.support.KryoValueEncoder;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class KryoValueDecoder
extends AbstractValueDecoder {
    public static final KryoValueDecoder INSTANCE = new KryoValueDecoder();

    @Override
    public Object apply(byte[] buffer) {
        try {
            this.checkHeader(buffer, KryoValueEncoder.IDENTITY_NUMBER);
            ByteArrayInputStream in = new ByteArrayInputStream(buffer, 4, buffer.length - 4);
            Input input = new Input((InputStream)in);
            Kryo kryo = KryoValueEncoder.kryoThreadLocal.get();
            return kryo.readClassAndObject(input);
        }
        catch (Exception e) {
            throw new CacheEncodeException("Kryo decode error: " + e.getMessage(), e);
        }
    }
}

