/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.support.JetCacheExecutor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshCache<K, V>
extends LoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(RefreshCache.class);
    private ConcurrentHashMap<Object, RefreshTask> taskMap = new ConcurrentHashMap();
    private static Method tryLockAndRunMethod;
    private static Method getMethod;
    private static Method putMethod;

    public RefreshCache(Cache cache) {
        super(cache);
    }

    protected void stopRefresh() {
        ArrayList<RefreshTask> tasks = new ArrayList<RefreshTask>();
        tasks.addAll(this.taskMap.values());
        tasks.forEach(task -> ((RefreshTask)task).cancel());
    }

    @Override
    public void close() {
        this.stopRefresh();
        super.close();
    }

    private boolean hasLoader() {
        return this.config.getLoader() != null;
    }

    protected Cache concreteCache() {
        Cache c = this.getTargetCache();
        while (true) {
            if (c instanceof ProxyCache) {
                c = ((ProxyCache)c).getTargetCache();
                continue;
            }
            if (!(c instanceof MultiLevelCache)) break;
            Cache[] caches = ((MultiLevelCache)c).caches();
            c = caches[caches.length - 1];
        }
        return c;
    }

    private Object getTaskId(K key) {
        Cache c = this.concreteCache();
        if (c instanceof AbstractEmbeddedCache) {
            return ((AbstractEmbeddedCache)c).buildKey(key);
        }
        if (c instanceof AbstractExternalCache) {
            byte[] bs = ((AbstractExternalCache)c).buildKey(key);
            return ByteBuffer.wrap(bs);
        }
        logger.error("can't getTaskId from " + c.getClass());
        return null;
    }

    private void addTaskOrUpdateLastAccessTime(Object taskId, long refreshMillis, K key) {
        if (refreshMillis > 0L && taskId != null) {
            RefreshTask refreshTask = this.taskMap.computeIfAbsent(taskId, (? super K tid) -> {
                RefreshTask task = new RefreshTask(taskId, key);
                task.lastAccessTime = System.currentTimeMillis();
                ScheduledFuture<?> future = JetCacheExecutor.heavyIOExecutor().scheduleWithFixedDelay(task, refreshMillis, refreshMillis, TimeUnit.MILLISECONDS);
                task.future = future;
                return task;
            });
            refreshTask.lastAccessTime = System.currentTimeMillis();
        }
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            this.addTaskOrUpdateLastAccessTime(this.getTaskId(key), this.config.getRefreshPolicy().getRefreshMillis(), key);
        }
        return this.cache.GET(key);
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            for (K key : keys) {
                this.addTaskOrUpdateLastAccessTime(this.getTaskId(key), this.config.getRefreshPolicy().getRefreshMillis(), key);
            }
        }
        return this.cache.GET_ALL(keys);
    }

    private byte[] combine(byte[] bs1, byte[] bs2) {
        byte[] newArray = Arrays.copyOf(bs1, bs1.length + bs2.length);
        System.arraycopy(bs2, 0, newArray, bs1.length, bs2.length);
        return newArray;
    }

    static {
        try {
            tryLockAndRunMethod = Cache.class.getMethod("tryLockAndRun", Object.class, Long.TYPE, TimeUnit.class, Runnable.class);
            getMethod = Cache.class.getMethod("GET", Object.class);
            putMethod = Cache.class.getMethod("put", Object.class, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new CacheException(e);
        }
    }

    class RefreshTask
    implements Runnable {
        private Object taskId;
        private K key;
        private long lastAccessTime;
        private ScheduledFuture future;

        RefreshTask(Object taskId, K key) {
            this.taskId = taskId;
            this.key = key;
        }

        private void cancel() {
            this.future.cancel(false);
            RefreshCache.this.taskMap.remove(this.taskId);
        }

        private void load() throws Throwable {
            logger.debug("refresh {}", this.key);
            CacheLoader loader = RefreshCache.this.config.getLoader();
            loader = CacheUtil.createProxyLoader(RefreshCache.this.cache, loader, (Consumer<CacheEvent>)RefreshCache.this.eventConsumer);
            Object v = loader.load(this.key);
            if (v != null || RefreshCache.this.config.isCacheNullValue()) {
                RefreshCache.this.cache.PUT(this.key, v);
            }
        }

        private void externalLoad(Cache concreteCache, long currentTime) throws Throwable {
            byte[] newKey = ((AbstractExternalCache)concreteCache).buildKey(this.key);
            byte[] lockKey = RefreshCache.this.combine(newKey, "_#RL#".getBytes());
            long loadTimeOut = RefreshCache.this.config.getRefreshPolicy().getRefreshLockTimeoutMillis();
            Runnable r = () -> {
                try {
                    long refreshMillis = RefreshCache.this.config.getRefreshPolicy().getRefreshMillis();
                    byte[] timestampKey = RefreshCache.this.combine(newKey, "_#TS#".getBytes());
                    CacheGetResult refreshTimeResult = (CacheGetResult)getMethod.invoke((Object)concreteCache, new Object[]{timestampKey});
                    if (refreshTimeResult.isSuccess() && currentTime < Long.parseLong(refreshTimeResult.getValue().toString()) + refreshMillis) {
                        return;
                    }
                    this.load();
                    putMethod.invoke((Object)concreteCache, timestampKey, String.valueOf(System.currentTimeMillis()));
                }
                catch (Throwable e) {
                    throw new CacheException("refresh error", e);
                }
            };
            tryLockAndRunMethod.invoke((Object)concreteCache, new Object[]{lockKey, loadTimeOut, TimeUnit.MILLISECONDS, r});
        }

        @Override
        public void run() {
            try {
                if (RefreshCache.this.config.getRefreshPolicy() == null || RefreshCache.this.config.getLoader() == null) {
                    this.cancel();
                    return;
                }
                long now = System.currentTimeMillis();
                long stopRefreshAfterLastAccessMillis = RefreshCache.this.config.getRefreshPolicy().getStopRefreshAfterLastAccessMillis();
                if (stopRefreshAfterLastAccessMillis > 0L && this.lastAccessTime + stopRefreshAfterLastAccessMillis < now) {
                    logger.debug("cancel refresh: {}", this.key);
                    this.cancel();
                    return;
                }
                Cache concreteCache = RefreshCache.this.concreteCache();
                if (concreteCache instanceof AbstractExternalCache) {
                    this.externalLoad(concreteCache, now);
                } else {
                    this.load();
                }
            }
            catch (Throwable e) {
                logger.error("refresh error: key=" + this.key, e);
            }
        }
    }
}

