/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.ResultData;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CacheGetResult<V>
extends CacheResult {
    private V value;
    public static final CacheGetResult NOT_EXISTS_WITHOUT_MSG = new CacheGetResult<Object>(CacheResultCode.NOT_EXISTS, null, null);
    public static final CacheGetResult EXPIRED_WITHOUT_MSG = new CacheGetResult<Object>(CacheResultCode.EXPIRED, null, null);

    public CacheGetResult(CacheResultCode resultCode, String message, V value) {
        super(CompletableFuture.completedFuture(new ResultData(resultCode, message, value)));
    }

    public CacheGetResult(CompletionStage<ResultData> future) {
        super(future);
    }

    public CacheGetResult(Throwable ex) {
        super(ex);
    }

    public V getValue() {
        this.waitForResult();
        return this.value;
    }

    @Override
    protected void fetchResultSuccess(ResultData resultData) {
        super.fetchResultSuccess(resultData);
        this.value = resultData.getData();
    }

    @Override
    protected void fetchResultFail(Throwable e) {
        super.fetchResultFail(e);
        this.value = null;
    }
}

