/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.LoadingCache;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.MultiLevelCache;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.embedded.AbstractEmbeddedCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.external.AbstractExternalCache;
import com.alicp.jetcache.support.JetCacheExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshCache<K, V>
extends LoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(RefreshCache.class);
    private ConcurrentHashMap<Object, RefreshTask> taskMap = new ConcurrentHashMap();

    public RefreshCache(Cache cache) {
        super(cache);
    }

    @Override
    public void close() {
        ArrayList<RefreshTask> tasks = new ArrayList<RefreshTask>();
        tasks.addAll(this.taskMap.values());
        tasks.forEach(task -> ((RefreshTask)task).cancel());
    }

    private boolean hasLoader() {
        return this.config.getLoader() != null;
    }

    private Cache concreteCache() {
        Cache c = this.getTargetCache();
        while (true) {
            if (c instanceof ProxyCache) {
                c = ((ProxyCache)c).getTargetCache();
                continue;
            }
            if (!(c instanceof MultiLevelCache)) break;
            Cache[] caches = ((MultiLevelCache)c).caches();
            c = caches[caches.length - 1];
        }
        return c;
    }

    private Object getTaskId(K key) {
        Cache c = this.concreteCache();
        if (c instanceof AbstractEmbeddedCache) {
            return ((AbstractEmbeddedCache)c).buildKey(key);
        }
        if (c instanceof AbstractExternalCache) {
            byte[] bs = ((AbstractExternalCache)c).buildKey(key);
            return ByteBuffer.wrap(bs);
        }
        logger.error("can't getTaskId from " + c.getClass());
        return null;
    }

    private void addTaskOrUpdateLastAccessTime(Object taskId, long refreshMillis, K key) {
        if (refreshMillis > 0L && taskId != null) {
            RefreshTask refreshTask = this.taskMap.computeIfAbsent(taskId, (? super K tid) -> {
                RefreshTask task = new RefreshTask(taskId, key);
                task.lastAccessTime = System.currentTimeMillis();
                ScheduledFuture<?> future = JetCacheExecutor.heavyIOExecutor().scheduleWithFixedDelay(task, refreshMillis, refreshMillis, TimeUnit.MILLISECONDS);
                task.future = future;
                return task;
            });
            refreshTask.lastAccessTime = System.currentTimeMillis();
        }
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            this.addTaskOrUpdateLastAccessTime(this.getTaskId(key), this.config.getRefreshPolicy().getRefreshMillis(), key);
        }
        return this.cache.GET(key);
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        if (this.config.getRefreshPolicy() != null && this.hasLoader()) {
            for (K key : keys) {
                this.addTaskOrUpdateLastAccessTime(this.getTaskId(key), this.config.getRefreshPolicy().getRefreshMillis(), key);
            }
        }
        return this.cache.GET_ALL(keys);
    }

    class RefreshTask
    implements Runnable {
        private Object taskId;
        private K key;
        private long lastAccessTime;
        private ScheduledFuture future;

        RefreshTask(Object taskId, K key) {
            this.taskId = taskId;
            this.key = key;
        }

        private void cancel() {
            this.future.cancel(false);
            RefreshCache.this.taskMap.remove(this.taskId);
        }

        private void load() {
            try {
                CacheLoader loader = RefreshCache.this.config.getLoader();
                loader = CacheUtil.createProxyLoader(RefreshCache.this.cache, loader, (Consumer<CacheEvent>)RefreshCache.this.eventConsumer);
                Object v = loader.load(this.key);
                RefreshCache.this.cache.PUT(this.key, v);
            }
            catch (Throwable e) {
                throw new CacheInvokeException(e);
            }
        }

        @Override
        public void run() {
            try {
                if (RefreshCache.this.config.getRefreshPolicy() == null || RefreshCache.this.config.getLoader() == null) {
                    this.cancel();
                    return;
                }
                long now = System.currentTimeMillis();
                long stopRefreshAfterLastAccessMillis = RefreshCache.this.config.getRefreshPolicy().getStopRefreshAfterLastAccessMillis();
                if (stopRefreshAfterLastAccessMillis > 0L && this.lastAccessTime + stopRefreshAfterLastAccessMillis < now) {
                    this.cancel();
                    return;
                }
                Cache c = RefreshCache.this.concreteCache();
                if (c instanceof AbstractExternalCache) {
                    byte[] suffix = "_#RL#".getBytes();
                    byte[] newKey = ((AbstractExternalCache)c).buildKey(this.key);
                    byte[] lockKey = Arrays.copyOf(newKey, newKey.length + suffix.length);
                    System.arraycopy(suffix, 0, lockKey, newKey.length, suffix.length);
                    long loadTimeOut = RefreshCache.this.config.getRefreshPolicy().getRefreshLockTimeoutMillis();
                    Method method = RefreshCache.this.cache.getClass().getMethod("tryLockAndRun", Object.class, Long.TYPE, TimeUnit.class, Runnable.class);
                    Runnable r = this::load;
                    method.invoke((Object)RefreshCache.this.cache, new Object[]{lockKey, loadTimeOut, TimeUnit.MILLISECONDS, r});
                } else {
                    this.load();
                }
            }
            catch (InvocationTargetException e) {
                logger.error("load key error: key=" + this.key, e.getTargetException());
            }
            catch (Throwable e) {
                logger.error("load key error: key=" + this.key, e);
            }
        }
    }
}

