/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.external.ExternalKeyUtil;
import java.io.IOException;

public abstract class AbstractExternalCache<K, V>
extends AbstractCache<K, V> {
    private ExternalCacheConfig config;

    public AbstractExternalCache(ExternalCacheConfig config) {
        this.config = config;
        if (config.getValueEncoder() == null) {
            throw new CacheConfigException("no value encoder");
        }
        if (config.getValueDecoder() == null) {
            throw new CacheConfigException("no value decoder");
        }
    }

    protected byte[] buildKey(Object key) {
        try {
            if (this.config.getKeyConvertor() != null) {
                key = this.config.getKeyConvertor().apply(key);
            }
            return ExternalKeyUtil.buildKeyAfterConvert(key, this.config.getKeyPrefix());
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }
}

