/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheBuilder;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public abstract class AbstractCacheBuilder<T extends AbstractCacheBuilder<T>>
implements CacheBuilder,
Cloneable {
    protected CacheConfig config;
    private Function<CacheConfig, Cache> buildFunc;

    public static CacheBuilderImpl createCacheBuilder() {
        return new CacheBuilderImpl();
    }

    protected AbstractCacheBuilder() {
    }

    protected CacheConfig getConfig() {
        if (this.config == null) {
            this.config = new CacheConfig();
        }
        return this.config;
    }

    protected T self() {
        return (T)this;
    }

    public T buildFunc(Function<CacheConfig, Cache> buildFunc) {
        this.buildFunc = buildFunc;
        return this.self();
    }

    protected void beforeBuild() {
    }

    @Deprecated
    public final <K, V> Cache<K, V> build() {
        return this.buildCache();
    }

    @Override
    public final <K, V> Cache<K, V> buildCache() {
        if (this.buildFunc == null) {
            throw new CacheConfigException("no buildFunc");
        }
        this.beforeBuild();
        return this.buildFunc.apply(this.getConfig().clone());
    }

    public Object clone() {
        AbstractCacheBuilder copy = null;
        try {
            copy = (AbstractCacheBuilder)super.clone();
            copy.config = this.getConfig().clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException(e);
        }
    }

    public T keyConvertor(Function<Object, Object> keyConvertor) {
        this.getConfig().setKeyConvertor(keyConvertor);
        return this.self();
    }

    public void setKeyConvertor(Function<Object, Object> keyConvertor) {
        this.getConfig().setKeyConvertor(keyConvertor);
    }

    public T expireAfterAccess(long defaultExpire, TimeUnit timeUnit) {
        this.getConfig().setDefaultExpireInMillis(timeUnit.toMillis(defaultExpire));
        this.getConfig().setExpireAfterAccess(true);
        return this.self();
    }

    public T expireAfterWrite(long defaultExpire, TimeUnit timeUnit) {
        this.getConfig().setDefaultExpireInMillis(timeUnit.toMillis(defaultExpire));
        this.getConfig().setExpireAfterAccess(false);
        return this.self();
    }

    public void setDefaultExpireInMillis(long defaultExpireInMillis) {
        this.getConfig().setDefaultExpireInMillis(defaultExpireInMillis);
    }

    public void setExpireAfterAccess(boolean expireAfterAccess) {
        this.getConfig().setExpireAfterAccess(expireAfterAccess);
    }

    public static class CacheBuilderImpl
    extends AbstractCacheBuilder<CacheBuilderImpl> {
    }
}

