/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.support.FastjsonKeyConvertor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(AbstractCache.class);

    protected abstract Object buildKey(K var1);

    protected void logError(String oper, Object key, Throwable e) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("jetcache(").append(this.getClass().getSimpleName()).append(") ").append(oper).append(" error. key=").append(FastjsonKeyConvertor.INSTANCE.apply(key)).append(".");
        if (this.needLogStackTrace(e)) {
            logger.error(sb.toString(), e);
        } else {
            sb.append(" Exception=").append(e.getClass()).append(", Message:").append(e.getMessage());
            logger.warn(sb.toString());
        }
    }

    protected boolean needLogStackTrace(Throwable e) {
        return true;
    }
}

