/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.embedded;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.embedded.EmbeddedCacheConfig;
import com.alicp.jetcache.embedded.InnerMap;
import com.alicp.jetcache.embedded.SimpleLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractEmbeddedCache<K, V>
extends AbstractCache<K, V> {
    protected EmbeddedCacheConfig config;
    protected InnerMap innerMap;

    protected abstract InnerMap createAreaCache();

    public AbstractEmbeddedCache(EmbeddedCacheConfig config) {
        this.config = config;
        this.innerMap = this.createAreaCache();
    }

    @Override
    public CacheConfig config() {
        return this.config;
    }

    @Override
    protected Object buildKey(K key) {
        if (key == null) {
            return null;
        }
        Object newKey = key;
        Function<Object, Object> keyConvertor = this.config.getKeyConvertor();
        if (keyConvertor != null) {
            newKey = keyConvertor.apply(key);
        }
        return newKey;
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        if (key == null) {
            return new CacheGetResult<Object>(CacheResultCode.FAIL, "illegal argument", null);
        }
        Object newKey = this.buildKey(key);
        CacheValueHolder holder = (CacheValueHolder)this.innerMap.getValue(newKey);
        return this.getImpl(holder);
    }

    private CacheGetResult<V> getImpl(CacheValueHolder<V> holder) {
        if (holder == null) {
            return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
        }
        if (System.currentTimeMillis() >= holder.getExpireTime()) {
            return CacheGetResult.EXPIRED_WITHOUT_MSG;
        }
        if (this.config.isExpireAfterAccess()) {
            long ttlInMillis = holder.getInitTtlInMillis();
            holder.setExpireTime(System.currentTimeMillis() + ttlInMillis);
        }
        return new CacheGetResult<V>(CacheResultCode.SUCCESS, null, holder.getValue());
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        ArrayList keyList = new ArrayList(keys.size());
        ArrayList newKeyList = new ArrayList(keys.size());
        keys.stream().forEach(k -> {
            Object newKey = this.buildKey(k);
            keyList.add(k);
            newKeyList.add(newKey);
        });
        Map innerResultMap = this.innerMap.getAllValues(newKeyList);
        HashMap resultMap = new HashMap();
        for (int i = 0; i < keyList.size(); ++i) {
            Object key = keyList.get(i);
            Object newKey = newKeyList.get(i);
            CacheValueHolder holder = (CacheValueHolder)innerResultMap.get(newKey);
            resultMap.put(key, this.getImpl(holder));
        }
        MultiGetResult result = new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
        return result;
    }

    @Override
    public CacheResult PUT(K key, V value, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(value, System.currentTimeMillis(), timeUnit.toMillis(expire));
        this.innerMap.putValue(this.buildKey(key), cacheObject);
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map, long expire, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        HashMap<Object, CacheValueHolder<V>> newKeyMap = new HashMap<Object, CacheValueHolder<V>>();
        for (Map.Entry<K, V> en : map.entrySet()) {
            CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(en.getValue(), System.currentTimeMillis(), timeUnit.toMillis(expire));
            newKeyMap.put(this.buildKey(en.getKey()), cacheObject);
        }
        this.innerMap.putAllValues(newKeyMap);
        HashMap resultMap = new HashMap();
        map.keySet().forEach(k -> resultMap.put(k, CacheResultCode.SUCCESS));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    public CacheResult REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        this.innerMap.removeValue(this.buildKey(key));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    public CacheResult REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        Set newKeys = keys.stream().map(key -> this.buildKey(key)).collect(Collectors.toSet());
        this.innerMap.removeAllValues(newKeys);
        HashMap resultMap = new HashMap();
        keys.forEach(k -> resultMap.put(k, CacheResultCode.SUCCESS));
        return CacheResult.SUCCESS_WITHOUT_MSG;
    }

    @Override
    public AutoReleaseLock tryLock(K key, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return null;
        }
        return SimpleLock.tryLock(this, this.buildKey(key), expire, timeUnit);
    }

    @Override
    public CacheResult PUT_IF_ABSENT(K key, V value, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        CacheValueHolder<V> cacheObject = new CacheValueHolder<V>(value, System.currentTimeMillis(), timeUnit.toMillis(expire));
        if (this.innerMap.putIfAbsentValue(this.buildKey(key), cacheObject)) {
            return CacheResult.SUCCESS_WITHOUT_MSG;
        }
        return CacheResult.EXISTS_WITHOUT_MSG;
    }
}

