/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.MultiGetResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MultiLevelCache<K, V>
implements Cache<K, V> {
    private Cache[] caches;

    public MultiLevelCache(Cache ... caches) {
        this.caches = caches;
    }

    public Cache[] caches() {
        return this.caches;
    }

    @Override
    public CacheConfig config() {
        return null;
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        if (key == null) {
            return new CacheGetResult<Object>(CacheResultCode.FAIL, "illegal argument", null);
        }
        for (int i = 0; i < this.caches.length; ++i) {
            Cache cache = this.caches[i];
            CacheValueHolder h = (CacheValueHolder)cache.get(key);
            if (!this.checkResultAndFillUpperCache(key, i, h)) continue;
            return new CacheGetResult(CacheResultCode.SUCCESS, null, h.getValue());
        }
        return CacheGetResult.NOT_EXISTS_WITHOUT_MSG;
    }

    private boolean checkResultAndFillUpperCache(K key, int i, CacheValueHolder<V> h) {
        if (h != null) {
            long currentExpire = h.getExpireTime();
            long now = System.currentTimeMillis();
            if (now <= currentExpire) {
                long restTtl = currentExpire - now;
                if (restTtl > 0L) {
                    this.PUT_caches(false, i, key, h.getValue(), restTtl, TimeUnit.MILLISECONDS);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return new MultiGetResult(CacheResultCode.FAIL, "illegal argument", null);
        }
        HashMap<Object, CacheGetResult> resultMap = new HashMap<Object, CacheGetResult>();
        HashSet<K> restKeys = new HashSet<K>(keys);
        for (int i = 0; i < this.caches.length && restKeys.size() != 0; ++i) {
            Cache c = this.caches[i];
            Map someResult = c.getAll(restKeys);
            for (Map.Entry en : someResult.entrySet()) {
                CacheValueHolder holder;
                K key = en.getKey();
                if (!this.checkResultAndFillUpperCache(key, i, holder = (CacheValueHolder)en.getValue())) continue;
                resultMap.put(key, new CacheGetResult(CacheResultCode.SUCCESS, null, holder.getValue()));
                restKeys.remove(key);
            }
        }
        for (Object k : restKeys) {
            resultMap.put(k, CacheGetResult.NOT_EXISTS_WITHOUT_MSG);
        }
        return new MultiGetResult(CacheResultCode.SUCCESS, null, resultMap);
    }

    @Override
    public CacheResult PUT(K key, V value) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT_caches(true, this.caches.length, key, value, Integer.MIN_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public CacheResult PUT(K key, V value, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        return this.PUT_caches(false, this.caches.length, key, value, expire, timeUnit);
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map) {
        return this.PUT_ALL_impl(true, map, Integer.MIN_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map, long expire, TimeUnit timeUnit) {
        return this.PUT_ALL_impl(false, map, expire, timeUnit);
    }

    private CacheResult PUT_ALL_impl(boolean useDefaultExpire, Map<? extends K, ? extends V> map, long expire, TimeUnit timeUnit) {
        if (map == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        int failCount = 0;
        for (Cache c : this.caches) {
            HashMap<K, CacheValueHolder<V>> newMap = new HashMap<K, CacheValueHolder<V>>();
            if (useDefaultExpire) {
                expire = c.config().getDefaultExpireInMillis();
                timeUnit = TimeUnit.MILLISECONDS;
            }
            for (Map.Entry<K, V> en : map.entrySet()) {
                CacheValueHolder<V> h = new CacheValueHolder<V>(en.getValue(), System.currentTimeMillis(), timeUnit.toMillis(expire));
                newMap.put(en.getKey(), h);
            }
            CacheResult r = useDefaultExpire ? c.PUT_ALL(newMap) : c.PUT_ALL(newMap, expire, timeUnit);
            if (r.isSuccess()) continue;
            ++failCount;
        }
        return failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == this.caches.length ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
    }

    private CacheResult PUT_caches(boolean useDefaultExpire, int lastIndex, K key, V value, long expire, TimeUnit timeUnit) {
        int failCount = 0;
        for (int i = 0; i < lastIndex; ++i) {
            Cache cache = this.caches[i];
            if (useDefaultExpire) {
                expire = cache.config().getDefaultExpireInMillis();
                timeUnit = TimeUnit.MILLISECONDS;
            }
            CacheValueHolder<V> h = new CacheValueHolder<V>(value, System.currentTimeMillis(), timeUnit.toMillis(expire));
            CacheResult r = useDefaultExpire ? cache.PUT(key, h) : cache.PUT(key, h, expire, timeUnit);
            if (r.isSuccess()) continue;
            ++failCount;
        }
        return failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == this.caches.length ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
    }

    @Override
    public CacheResult REMOVE(K key) {
        if (key == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        int failCount = 0;
        for (Cache cache : this.caches) {
            CacheResult r = cache.REMOVE(key);
            if (r.isSuccess()) continue;
            ++failCount;
        }
        return failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == this.caches.length ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
    }

    @Override
    public CacheResult REMOVE_ALL(Set<? extends K> keys) {
        if (keys == null) {
            return CacheResult.FAIL_ILLEGAL_ARGUMENT;
        }
        int failCount = 0;
        for (Cache cache : this.caches) {
            CacheResult r = cache.REMOVE_ALL(keys);
            if (r.isSuccess()) continue;
            ++failCount;
        }
        return failCount == 0 ? CacheResult.SUCCESS_WITHOUT_MSG : (failCount == this.caches.length ? CacheResult.FAIL_WITHOUT_MSG : CacheResult.PART_SUCCESS_WITHOUT_MSG);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("unwrap is not supported by MultiLevelCache");
    }

    @Override
    public AutoReleaseLock tryLock(K key, long expire, TimeUnit timeUnit) {
        if (key == null) {
            return null;
        }
        return this.caches[this.caches.length - 1].tryLock(key, expire, timeUnit);
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("putIfAbsent is not supported by MultiLevelCache");
    }

    @Override
    public CacheResult PUT_IF_ABSENT(K key, V value, long expire, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("PUT_IF_ABSENT is not supported by MultiLevelCache");
    }
}

