/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheMonitor;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheGetAllEvent;
import com.alicp.jetcache.event.CacheGetEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import com.alicp.jetcache.event.CachePutAllEvent;
import com.alicp.jetcache.event.CachePutEvent;
import com.alicp.jetcache.event.CacheRemoveAllEvent;
import com.alicp.jetcache.event.CacheRemoveEvent;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class MonitoredCache<K, V>
implements ProxyCache<K, V> {
    private CacheMonitor[] monitors;
    private Cache<K, V> cache;

    public MonitoredCache(Cache<K, V> cache, CacheMonitor ... monitor) {
        this.cache = cache;
        Objects.requireNonNull(monitor);
        this.monitors = monitor;
    }

    @Override
    public Cache<K, V> getTargetCache() {
        return this.cache;
    }

    public CacheMonitor[] getMonitors() {
        return this.monitors;
    }

    @Override
    public CacheConfig config() {
        return this.cache.config();
    }

    public void notity(CacheEvent e) {
        for (CacheMonitor m : this.monitors) {
            m.afterOperation(e);
        }
    }

    @Override
    public CacheGetResult<V> GET(K key) {
        long t = System.currentTimeMillis();
        CacheGetResult<V> result = this.cache.GET(key);
        t = System.currentTimeMillis() - t;
        CacheGetEvent event = new CacheGetEvent(this.cache, t, key, result);
        this.notity(event);
        return result;
    }

    @Override
    public MultiGetResult<K, V> GET_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        MultiGetResult<? extends K, V> result = this.cache.GET_ALL(keys);
        t = System.currentTimeMillis() - t;
        CacheGetAllEvent event = new CacheGetAllEvent(this.cache, t, keys, result);
        this.notity(event);
        return result;
    }

    private Function<K, V> createProxyLoader(K key, Function<K, V> loader) {
        return k -> {
            long t = System.currentTimeMillis();
            Object v = null;
            boolean success = false;
            try {
                v = loader.apply(k);
                success = true;
            }
            finally {
                t = System.currentTimeMillis() - t;
                CacheLoadEvent event = new CacheLoadEvent(this.cache, t, key, v, success);
                this.notity(event);
            }
            return v;
        };
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull) {
        Function<K, V> newLoader = this.createProxyLoader(key, loader);
        return ProxyCache.super.computeIfAbsent(key, newLoader, cacheNullWhenLoaderReturnNull);
    }

    @Override
    public V computeIfAbsent(K key, Function<K, V> loader, boolean cacheNullWhenLoaderReturnNull, long expire, TimeUnit timeUnit) {
        Function<K, V> newLoader = this.createProxyLoader(key, loader);
        return ProxyCache.super.computeIfAbsent(key, newLoader, cacheNullWhenLoaderReturnNull, expire, timeUnit);
    }

    @Override
    public CacheResult PUT(K key, V value) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.PUT(key, value);
        t = System.currentTimeMillis() - t;
        CachePutEvent event = new CachePutEvent(this.cache, t, key, value, result);
        this.notity(event);
        return result;
    }

    @Override
    public CacheResult PUT(K key, V value, long expire, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.PUT(key, value, expire, timeUnit);
        t = System.currentTimeMillis() - t;
        CachePutEvent event = new CachePutEvent(this.cache, t, key, value, result);
        this.notity(event);
        return result;
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.PUT_ALL(map);
        t = System.currentTimeMillis() - t;
        CachePutAllEvent event = new CachePutAllEvent(this.cache, t, map, result);
        this.notity(event);
        return result;
    }

    @Override
    public CacheResult PUT_ALL(Map<? extends K, ? extends V> map, long expire, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.PUT_ALL(map, expire, timeUnit);
        t = System.currentTimeMillis() - t;
        CachePutAllEvent event = new CachePutAllEvent(this.cache, t, map, result);
        this.notity(event);
        return result;
    }

    @Override
    public CacheResult REMOVE(K key) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.REMOVE(key);
        t = System.currentTimeMillis() - t;
        CacheRemoveEvent event = new CacheRemoveEvent(this.cache, t, key, result);
        this.notity(event);
        return result;
    }

    @Override
    public CacheResult REMOVE_ALL(Set<? extends K> keys) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.REMOVE_ALL(keys);
        t = System.currentTimeMillis() - t;
        CacheRemoveAllEvent event = new CacheRemoveAllEvent(this.cache, t, keys, result);
        this.notity(event);
        return result;
    }

    @Override
    public AutoReleaseLock tryLock(K key, long expire, TimeUnit timeUnit) {
        return this.cache.tryLock(key, expire, timeUnit);
    }

    @Override
    public CacheResult PUT_IF_ABSENT(K key, V value, long expire, TimeUnit timeUnit) {
        long t = System.currentTimeMillis();
        CacheResult result = this.cache.PUT_IF_ABSENT(key, value, expire, timeUnit);
        t = System.currentTimeMillis() - t;
        CachePutEvent event = new CachePutEvent(this.cache, t, key, value, result);
        this.notity(event);
        return result;
    }
}

