/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.support.CacheStat;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheMonitorManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCacheMonitorManager.class);
    protected static ScheduledExecutorService executorService;
    protected CopyOnWriteArrayList<DefaultCacheMonitor> monitorList = new CopyOnWriteArrayList();
    private ScheduledFuture<?> future;
    private int resetTime;
    private TimeUnit resetTimeUnit;
    private Consumer<StatInfo> statCallback;

    public DefaultCacheMonitorManager(int resetTime, TimeUnit resetTimeUnit, Consumer<StatInfo> statCallback) {
        this.resetTime = resetTime;
        this.resetTimeUnit = resetTimeUnit;
        this.statCallback = statCallback;
    }

    public DefaultCacheMonitorManager(int resetTime, TimeUnit resetTimeUnit) {
        this(resetTime, resetTimeUnit, false);
    }

    public DefaultCacheMonitorManager(int resetTime, TimeUnit resetTimeUnit, boolean verboseLog) {
        this.resetTime = resetTime;
        this.resetTimeUnit = resetTimeUnit;
        this.statCallback = new StatInfoLogger(verboseLog);
    }

    @PostConstruct
    public synchronized void start() {
        if (this.future != null) {
            return;
        }
        if (executorService == null) {
            DefaultCacheMonitorManager.initExecutor();
        }
        Runnable cmd = new Runnable(){
            private long time = System.currentTimeMillis();

            @Override
            public void run() {
                try {
                    List<CacheStat> stats = DefaultCacheMonitorManager.this.monitorList.stream().map(m -> {
                        CacheStat stat = m.getCacheStat();
                        m.resetStat();
                        return stat;
                    }).collect(Collectors.toList());
                    long endTime = System.currentTimeMillis();
                    StatInfo statInfo = new StatInfo();
                    statInfo.setStartTime(this.time);
                    statInfo.setEndTime(endTime);
                    statInfo.setStats(stats);
                    this.time = endTime;
                    DefaultCacheMonitorManager.this.statCallback.accept(statInfo);
                }
                catch (Exception e) {
                    logger.error("jetcache DefaultCacheMonitorManager error", (Throwable)e);
                }
            }
        };
        long delay = DefaultCacheMonitorManager.firstDelay(this.resetTime, this.resetTimeUnit);
        this.future = executorService.scheduleAtFixedRate(cmd, delay, this.resetTimeUnit.toMillis(this.resetTime), TimeUnit.MILLISECONDS);
        logger.info("cache stat period at " + this.resetTime + " " + (Object)((Object)this.resetTimeUnit));
    }

    @PreDestroy
    public synchronized void stop() {
        this.future.cancel(false);
        logger.info("cache stat canceled");
        this.future = null;
    }

    public DefaultCacheMonitorManager add(DefaultCacheMonitor ... monitors) {
        this.monitorList.addAll(Arrays.asList(monitors));
        return this;
    }

    public DefaultCacheMonitorManager remove(DefaultCacheMonitor ... monitor) {
        this.monitorList.remove(monitor);
        return this;
    }

    public static ScheduledExecutorService executorService() {
        if (executorService != null) {
            return executorService;
        }
        DefaultCacheMonitorManager.initExecutor();
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initExecutor() {
        Class<DefaultCacheMonitor> clazz = DefaultCacheMonitor.class;
        synchronized (DefaultCacheMonitor.class) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = new Thread(r, "JetCacheMonitorThread");
                    t.setDaemon(true);
                    return t;
                });
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static long firstDelay(int resetTime, TimeUnit resetTimeUnit) {
        LocalDateTime firstResetTime = DefaultCacheMonitorManager.computeFirstResetTime(LocalDateTime.now(), resetTime, resetTimeUnit);
        return firstResetTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - System.currentTimeMillis();
    }

    protected static LocalDateTime computeFirstResetTime(LocalDateTime baseTime, int time, TimeUnit unit) {
        if (unit != TimeUnit.SECONDS && unit != TimeUnit.MINUTES && unit != TimeUnit.HOURS && unit != TimeUnit.DAYS) {
            throw new IllegalArgumentException();
        }
        LocalDateTime t = baseTime;
        switch (unit) {
            case DAYS: {
                t = t.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                break;
            }
            case HOURS: {
                t = 24 % time == 0 ? t.plusHours(time - t.getHour() % time) : t.plusHours(1L);
                t = t.withMinute(0).withSecond(0).withNano(0);
                break;
            }
            case MINUTES: {
                t = 60 % time == 0 ? t.plusMinutes(time - t.getMinute() % time) : t.plusMinutes(1L);
                t = t.withSecond(0).withNano(0);
                break;
            }
            case SECONDS: {
                t = 60 % time == 0 ? t.plusSeconds(time - t.getSecond() % time) : t.plusSeconds(1L);
                t = t.withNano(0);
            }
        }
        return t;
    }
}

