/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.kryo.serializer;

import com.alibaba.kryo.serializer.CacheSessionKryoPolicy;
import com.alibaba.kryo.serializer.CreateOption;
import com.alibaba.kryo.serializer.ReadWriteSessionDataLocator;
import com.alibaba.kryo.serializer.SessionKryo;
import com.alibaba.kryo.serializer.SessionKryoFactory;

public class SessionKryoService {
    public static SessionKryoFactory newSingletonSessionKryoFactory(final ReadWriteSessionDataLocator readWriteSessionDataLocator, final CreateOption createOption) {
        return new SessionKryoFactory(){
            private SessionKryo sessionKryo;
            {
                this.sessionKryo = SessionKryoService.createSessionKryo(readWriteSessionDataLocator, createOption);
            }

            @Override
            public <T> SessionKryo get(T locateKey) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SessionKryo get() {
                return this.sessionKryo;
            }
        };
    }

    public static SessionKryoFactory newThreadLocalSessionKryoFactory(final ReadWriteSessionDataLocator readWriteSessionDataLocator, final CreateOption createOption) {
        return new SessionKryoFactory(){

            @Override
            public <T> SessionKryo get(T locateKey) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SessionKryo get() {
                SessionKryo kryo = KryoThreadLocal.get();
                if (kryo == null) {
                    kryo = SessionKryoService.createSessionKryo(readWriteSessionDataLocator, createOption);
                    KryoThreadLocal.set(kryo);
                }
                return kryo;
            }
        };
    }

    public static SessionKryoFactory newCachedSessionKryoFactory(final CacheSessionKryoPolicy cachePolicy, final ReadWriteSessionDataLocator readWriteSessionDataLocator, final CreateOption createOption) {
        return new SessionKryoFactory(){

            @Override
            public <T> SessionKryo get(T locateKey) {
                SessionKryo kryo = cachePolicy.get(locateKey);
                if (kryo == null) {
                    kryo = SessionKryoService.createSessionKryo(readWriteSessionDataLocator, createOption);
                    cachePolicy.put(locateKey, kryo);
                }
                return kryo;
            }

            @Override
            public SessionKryo get() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static SessionKryo createSessionKryo(ReadWriteSessionDataLocator readWriteSessionDataLocator, CreateOption createOption) {
        SessionKryo sessionKryo = new SessionKryo(readWriteSessionDataLocator, createOption);
        return sessionKryo;
    }

    private static class KryoThreadLocal {
        private static final ThreadLocal<SessionKryo> context = new ThreadLocal();

        private KryoThreadLocal() {
        }

        public static void set(SessionKryo sessionalKryo) {
            context.set(sessionalKryo);
        }

        public static SessionKryo get() {
            return context.get();
        }
    }
}

