/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.kryo.serializer;

import com.alibaba.kryo.serializer.CachedClassResolver;
import com.alibaba.kryo.serializer.CreateOption;
import com.alibaba.kryo.serializer.FastCachedCompatibleFieldSerializer;
import com.alibaba.kryo.serializer.KnownTypes;
import com.alibaba.kryo.serializer.ReadWriteSessionData;
import com.alibaba.kryo.serializer.ReadWriteSessionDataLocator;
import com.alibaba.kryo.serializer.YummyObject;
import com.esotericsoftware.kryo.kryo5.ClassResolver;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.ReferenceResolver;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.SerializerFactory;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.objenesis.strategy.InstantiatorStrategy;
import com.esotericsoftware.kryo.kryo5.objenesis.strategy.StdInstantiatorStrategy;
import com.esotericsoftware.kryo.kryo5.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.kryo5.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.kryo5.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.kryo5.util.MapReferenceResolver;
import java.util.PriorityQueue;

public class SessionKryo {
    private final ReadWriteSessionDataLocator readWriteSessionDataLocator;
    private final Kryo kryo;
    private final CreateOption createOption;
    KnownTypes knownTypes;
    ReadWriteSessionData sessionData;
    final YummyObject yummyObject = new YummyObject();
    private final CachedClassResolver cachedClassResolver;
    private final IdentityObjectIntMap<Class> classToSize = new IdentityObjectIntMap();
    private static final int DEFAULT_OUTPUT_SIZE = 4096;

    public SessionKryo(ReadWriteSessionDataLocator readWriteSessionDataLocator, CreateOption createOption) {
        this.createOption = createOption;
        this.cachedClassResolver = new CachedClassResolver(this);
        this.readWriteSessionDataLocator = readWriteSessionDataLocator;
        this.kryo = new Kryo((ClassResolver)this.cachedClassResolver, (ReferenceResolver)new MapReferenceResolver());
        this.kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        this.kryo.setRegistrationRequired(false);
        this.kryo.setReferences(true);
        this.kryo.setOptimizedGenerics(false);
        this.kryo.setDefaultSerializer((SerializerFactory)new OffsetSkipableCachedCompatibleFieldSerializerFactory(createOption.supportSameFieldNameWithSuper));
        this.kryo.addDefaultSerializer(PriorityQueue.class, (Serializer)new CanEmptyPriorityQueueSerializer());
        this.knownTypes = new KnownTypes(this.kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] writeClassAndObject(T sessionLocateKey, Object object) {
        try {
            this.sessionData = this.findSessionData(sessionLocateKey);
            Output output = this.createOutput(object);
            this.kryo.writeClassAndObject(output, object);
            if (object != null) {
                this.recordClassSize(object.getClass(), (int)output.total());
            }
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            this.sessionData.resetWriteData();
            this.sessionData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] writeObject(T sessionLocateKey, Object object) {
        try {
            this.sessionData = this.findSessionData(sessionLocateKey);
            Output output = this.createOutput(object);
            this.kryo.writeObject(output, object);
            if (object != null) {
                this.recordClassSize(object.getClass(), (int)output.total());
            }
            byte[] byArray = output.toBytes();
            return byArray;
        }
        finally {
            this.sessionData.resetWriteData();
            this.sessionData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Object readClassAndObject(T sessionLocateKey, byte[] buffer) {
        try {
            this.sessionData = this.findSessionData(sessionLocateKey);
            Input input = new Input(buffer);
            Object object = this.kryo.readClassAndObject(input);
            return object;
        }
        finally {
            this.sessionData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readObject(T sessionLocateKey, byte[] buffer, Class<T> type) {
        try {
            this.sessionData = this.findSessionData(sessionLocateKey);
            Input input = new Input(buffer);
            Object object = this.kryo.readObject(input, type);
            return (T)object;
        }
        finally {
            this.sessionData = null;
        }
    }

    private <T> ReadWriteSessionData findSessionData(T sessionLocateKey) {
        ReadWriteSessionData sessionData = this.readWriteSessionDataLocator.find(sessionLocateKey);
        if (sessionData == null) {
            sessionData = new ReadWriteSessionData();
            this.readWriteSessionDataLocator.newCreated(sessionLocateKey, sessionData);
        }
        return sessionData;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.kryo.setClassLoader(classLoader);
    }

    private Output createOutput(Object o) {
        if (o != null) {
            return new Output(this.getClassOutputSize(o.getClass()), this.createOption.maxOutputBufferSize);
        }
        return new Output(8, this.createOption.maxOutputBufferSize);
    }

    private void recordClassSize(Class type, int size) {
        if (size > 0) {
            this.classToSize.put((Object)type, size);
        }
    }

    private int getClassOutputSize(Class type) {
        return this.classToSize.get((Object)type, 4096);
    }

    public static class CanEmptyPriorityQueueSerializer
    extends DefaultSerializers.PriorityQueueSerializer {
        protected PriorityQueue create(Kryo kryo, Input input, Class<? extends PriorityQueue> type, int size) {
            return super.create(kryo, input, type, size < 1 ? 1 : size);
        }
    }

    static class OffsetSkipableCachedCompatibleFieldSerializerFactory
    extends SerializerFactory.BaseSerializerFactory<FastCachedCompatibleFieldSerializer> {
        private final FastCachedCompatibleFieldSerializer.CachedCompatibleFieldSerializerConfig config = new FastCachedCompatibleFieldSerializer.CachedCompatibleFieldSerializerConfig();

        public OffsetSkipableCachedCompatibleFieldSerializerFactory(boolean supportSameFieldNameWithSuper) {
            if (supportSameFieldNameWithSuper) {
                this.config.setExtendedFieldNames(true);
            }
        }

        public FastCachedCompatibleFieldSerializer.CachedCompatibleFieldSerializerConfig getConfig() {
            return this.config;
        }

        public FastCachedCompatibleFieldSerializer newSerializer(Kryo kryo, Class type) {
            return new FastCachedCompatibleFieldSerializer(kryo, type, this.config.clone());
        }
    }
}

