/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.kryo.serializer;

import com.alibaba.kryo.serializer.ApplicationShareData;
import com.alibaba.kryo.serializer.CachedClassResolver;
import com.alibaba.kryo.serializer.FieldsDefaultType;
import com.alibaba.kryo.serializer.KnownTypes;
import com.alibaba.kryo.serializer.ReadMetaInfo;
import com.alibaba.kryo.serializer.ReadWriteSessionData;
import com.alibaba.kryo.serializer.SessionKryo;
import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.esotericsoftware.kryo.kryo5.unsafe.UnsafeUtil;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.util.Arrays;
import java.util.Comparator;

public class FastCachedCompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    public static final int SHORTER_FIELD_LEN = 255;
    public static final int LONGER_FIELD = 0;
    private static final byte fields_flag = -1;
    private static final byte no_fields_flag = -2;
    private final CachedCompatibleFieldSerializerConfig config;
    private static final QuickSkipSerializer quickSkipSerializer = new QuickSkipSerializer();
    private SessionKryo sessionKryo;

    public FastCachedCompatibleFieldSerializer(Kryo kryo, Class type) {
        this(kryo, type, new CachedCompatibleFieldSerializerConfig());
        this.sessionKryo = ((CachedClassResolver)kryo.getClassResolver()).sessionKryo;
    }

    protected void initializeCachedFields() {
        super.initializeCachedFields();
        if (Util.unsafe) {
            try {
                final long offset = UnsafeUtil.unsafe.objectFieldOffset(FieldSerializer.CachedField.class.getDeclaredField("offset"));
                FieldSerializer.CachedField[] fields = this.getFields();
                Arrays.sort(fields, new Comparator<FieldSerializer.CachedField>(){

                    @Override
                    public int compare(FieldSerializer.CachedField o1, FieldSerializer.CachedField o2) {
                        long b;
                        long a = UnsafeUtil.unsafe.getLong(o1, offset);
                        return a < (b = UnsafeUtil.unsafe.getLong(o2, offset)) ? -1 : (a > b ? 1 : 0);
                    }
                });
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public FastCachedCompatibleFieldSerializer(Kryo kryo, Class type, CachedCompatibleFieldSerializerConfig config) {
        super(kryo, type, (FieldSerializer.FieldSerializerConfig)config);
        this.config = config;
        this.sessionKryo = ((CachedClassResolver)kryo.getClassResolver()).sessionKryo;
    }

    public void write(Kryo kryo, Output output, T object) {
        int pop = this.pushTypeVariables();
        ReadWriteSessionData sessionData = this.sessionKryo.sessionData;
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        FieldsDefaultType fieldsDefaultType = null;
        if (!context.containsKey((Object)this)) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write fields for class: " + this.getType().getName()));
            }
            context.put((Object)this, null);
            if (!sessionData.writeClassToNameId.containsKey((Object)this.getType())) {
                int nameId = sessionData.writeNextNameId++;
                sessionData.writeClassToNameId.put((Object)this.getType(), nameId);
                sessionData.toWrittenFieldClassSet.add(this.getType());
            }
            if (!sessionData.toWrittenFieldClassSet.contains(this.getType())) {
                output.writeByte((byte)-2);
            } else {
                output.writeByte((byte)-1);
                output.writeVarInt(fields.length, true);
                fieldsDefaultType = ApplicationShareData.writtenField.get(this.getType());
                if (fieldsDefaultType != null) {
                    int n = fields.length;
                    for (int i = 0; i < n; ++i) {
                        if (Log.TRACE) {
                            Log.trace((String)"kryo", (String)("Write field name: " + fields[i].getName() + Util.pos((int)output.position())));
                        }
                        output.writeString(fields[i].getName());
                    }
                    output.writeBytes(fieldsDefaultType.fieldsCode);
                } else {
                    fieldsDefaultType = new FieldsDefaultType(fields.length);
                    int notDefaultTypeFieldNum = 0;
                    int n = fields.length;
                    for (int i = 0; i < n; ++i) {
                        byte typeCode;
                        if (Log.TRACE) {
                            Log.trace((String)"kryo", (String)("Write field name: " + fields[i].getName() + Util.pos((int)output.position())));
                        }
                        output.writeString(fields[i].getName());
                        fieldsDefaultType.fieldsCode[i] = typeCode = (byte)KnownTypes.class2Code.get(fields[i].getField().getType(), 0);
                        if (typeCode != 0) continue;
                        ++notDefaultTypeFieldNum;
                    }
                    if (notDefaultTypeFieldNum > 0) {
                        fieldsDefaultType.containVarLenField = true;
                        fieldsDefaultType.varLenField = new byte[notDefaultTypeFieldNum];
                    } else {
                        fieldsDefaultType.containVarLenField = false;
                    }
                    output.writeBytes(fieldsDefaultType.fieldsCode);
                    ApplicationShareData.writtenField.put(this.getType(), fieldsDefaultType);
                }
            }
        }
        Output fieldOutput = output;
        if (fieldsDefaultType == null) {
            fieldsDefaultType = ApplicationShareData.writtenField.get(this.getType());
        }
        if (fieldsDefaultType.containVarLenField) {
            int i;
            int varLenSmallerPos = output.position();
            output.writeBytes(fieldsDefaultType.varLenField);
            int varLenLargerPos = output.position();
            output.writeInt(0);
            int varLenFieldNum = 0;
            int largerFieldNum = 0;
            int[] longerFieldLength = new int[fieldsDefaultType.varLenField.length];
            int n = fields.length;
            for (i = 0; i < n; ++i) {
                int startPos = output.position();
                FieldSerializer.CachedField cachedField = fields[i];
                if (Log.TRACE) {
                    this.log("Write", cachedField, output.position());
                }
                cachedField.write(fieldOutput, object);
                if (fieldsDefaultType.fieldsCode[i] != 0) continue;
                int size = output.position() - startPos;
                if (size <= 255) {
                    output.getBuffer()[varLenSmallerPos + varLenFieldNum] = (byte)size;
                } else {
                    output.getBuffer()[varLenSmallerPos + varLenFieldNum] = 0;
                    longerFieldLength[largerFieldNum++] = size;
                }
                ++varLenFieldNum;
            }
            if (largerFieldNum > 0) {
                this.writeInAt(output.getBuffer(), varLenLargerPos, output.position() - varLenLargerPos);
                output.writeInt(largerFieldNum);
                for (i = 0; i < largerFieldNum; ++i) {
                    output.writeInt(longerFieldLength[i]);
                }
            }
        } else {
            for (FieldSerializer.CachedField cachedField : fields) {
                if (Log.TRACE) {
                    this.log("Write", cachedField, output.position());
                }
                cachedField.write(fieldOutput, object);
            }
        }
        this.popTypeVariables(pop);
    }

    private void writeInAt(byte[] buffer, int p, int value) {
        buffer[p] = (byte)value;
        buffer[p + 1] = (byte)(value >> 8);
        buffer[p + 2] = (byte)(value >> 16);
        buffer[p + 3] = (byte)(value >> 24);
    }

    private int readIntAt(byte[] buffer, int p) {
        return buffer[p] & 0xFF | (buffer[p + 1] & 0xFF) << 8 | (buffer[p + 2] & 0xFF) << 16 | (buffer[p + 3] & 0xFF) << 24;
    }

    public T read(Kryo kryo, Input input, Class<? extends T> type) {
        int pop = this.pushTypeVariables();
        ReadWriteSessionData sessionData = this.sessionKryo.sessionData;
        Object object = this.create(kryo, input, type);
        kryo.reference(object);
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])kryo.getGraphContext().get((Object)this);
        ReadFieldContext readFieldContext = new ReadFieldContext();
        if (fields == null) {
            fields = this.readFields(kryo, input, readFieldContext, sessionData);
        } else {
            readFieldContext.readMetaInfo = (ReadMetaInfo)sessionData.readNameToMeta.get((Object)this.getType());
        }
        if (readFieldContext.readMetaInfo != null) {
            if (readFieldContext.readMetaInfo.varLenFieldNum > 0) {
                int largerFieldNum;
                byte[] sizeArray = input.readBytes(readFieldContext.readMetaInfo.varLenFieldNum);
                int pointerBasePos = input.position();
                int offsetToVarLen = input.readInt();
                int n = largerFieldNum = offsetToVarLen == 0 ? 0 : this.readIntAt(input.getBuffer(), pointerBasePos + offsetToVarLen);
                if (readFieldContext.readMetaInfo.sameLayout) {
                    int n2 = fields.length;
                    for (int i = 0; i < n2; ++i) {
                        fields[i].read(input, object);
                    }
                } else {
                    int varLenIndex = 0;
                    int largeFieldIndex = 0;
                    byte[] fieldTypeCode = readFieldContext.readMetaInfo.fieldsCode;
                    int n3 = fields.length;
                    for (int i = 0; i < n3; ++i) {
                        FieldSerializer.CachedField cachedField = fields[i];
                        if (cachedField != null) {
                            fields[i].read(input, object);
                        } else if (fieldTypeCode[i] == 0) {
                            if (sizeArray[varLenIndex] == 0) {
                                quickSkipSerializer.skip(kryo, input, this.readIntAt(input.getBuffer(), pointerBasePos + offsetToVarLen + (largeFieldIndex + 1 << 2)));
                            } else {
                                quickSkipSerializer.skip(kryo, input, sizeArray[varLenIndex] & 0xFF);
                            }
                        } else {
                            this.sessionKryo.knownTypes.code2Serializer[fieldTypeCode[i]].read(input, (Object)this.sessionKryo.yummyObject);
                        }
                        if (fieldTypeCode[i] != 0) continue;
                        if (sizeArray[varLenIndex] == 0) {
                            ++largeFieldIndex;
                        }
                        ++varLenIndex;
                    }
                }
                if (largerFieldNum > 0) {
                    input.skip(largerFieldNum + 1 << 2);
                }
            } else if (readFieldContext.readMetaInfo.sameLayout) {
                int n = fields.length;
                for (int i = 0; i < n; ++i) {
                    fields[i].read(input, object);
                }
            } else {
                byte[] fieldTypeCode = readFieldContext.readMetaInfo.fieldsCode;
                int n = fields.length;
                for (int i = 0; i < n; ++i) {
                    FieldSerializer.CachedField cachedField = fields[i];
                    if (cachedField != null) {
                        fields[i].read(input, object);
                        continue;
                    }
                    this.sessionKryo.knownTypes.code2Serializer[fieldTypeCode[i]].read(input, (Object)this.sessionKryo.yummyObject);
                }
            }
        } else {
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                fields[i].read(input, object);
            }
        }
        this.popTypeVariables(pop);
        return (T)object;
    }

    private FieldSerializer.CachedField[] readFields(Kryo kryo, Input input, ReadFieldContext fieldContext, ReadWriteSessionData sessionData) {
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read fields for class: " + this.getType().getName()));
        }
        byte flag = input.readByte();
        String[] names = null;
        int length = 0;
        ReadMetaInfo readMetaInfo = null;
        if (flag == -1) {
            length = input.readVarInt(true);
            names = new String[length];
            for (int i = 0; i < length; ++i) {
                names[i] = input.readString();
                if (!Log.TRACE) continue;
                Log.trace((String)"kryo", (String)("Read field name: " + names[i]));
            }
            byte[] fieldsCode = new byte[length];
            input.readBytes(fieldsCode);
            String key = this.getKey(this.getType(), names, fieldsCode);
            readMetaInfo = ApplicationShareData.readMetaInfoMap.get(key);
            if (readMetaInfo == null) {
                readMetaInfo = this.buildReadMetaInfo(this.getType(), names, fieldsCode);
                ApplicationShareData.readMetaInfoMap.put(key, readMetaInfo);
            }
            sessionData.readNameToMeta.put((Object)this.getType(), (Object)readMetaInfo);
        } else if (flag == -2) {
            readMetaInfo = (ReadMetaInfo)sessionData.readNameToMeta.get((Object)this.getType());
            if (null == readMetaInfo) {
                FieldSerializer.CachedField[] fields = this.getFields();
                kryo.getGraphContext().put((Object)this, (Object)fields);
                return fields;
            }
            names = readMetaInfo.fields;
            length = names == null ? 0 : names.length;
        }
        FieldSerializer.CachedField[] fields = readMetaInfo.sameLayout ? this.getFields() : this.matchFieldsQuick(length, readMetaInfo);
        kryo.getGraphContext().put((Object)this, (Object)fields);
        fieldContext.readMetaInfo = readMetaInfo;
        return fields;
    }

    private ReadMetaInfo buildReadMetaInfo(Class type, String[] names, byte[] fieldsCode) {
        int length = names.length;
        ReadMetaInfo readMetaInfo = new ReadMetaInfo(type, fieldsCode);
        readMetaInfo.fields = names;
        readMetaInfo.varLenFieldNum = this.getVarLenFieldNum(fieldsCode);
        FieldSerializer.CachedField[] allFields = this.getFields();
        int foundMatchFieldNum = 0;
        readMetaInfo.fieldIndexMap = new int[length];
        block0: for (int i = 0; i < names.length; ++i) {
            String schemaName = names[i];
            readMetaInfo.fieldIndexMap[i] = -1;
            int nn = allFields.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (!allFields[ii].getName().equals(schemaName)) continue;
                ++foundMatchFieldNum;
                readMetaInfo.fieldIndexMap[i] = ii;
                continue block0;
            }
            if (!Log.TRACE) continue;
            Log.trace((String)"kryo", (String)("Unknown field will be skipped: " + schemaName));
        }
        if (length == allFields.length && foundMatchFieldNum == length) {
            readMetaInfo.sameLayout = true;
        }
        return readMetaInfo;
    }

    private int getVarLenFieldNum(byte[] fieldsCode) {
        int varLenFieldNum = 0;
        for (int i = 0; i < fieldsCode.length; ++i) {
            if (fieldsCode[i] != 0) continue;
            ++varLenFieldNum;
        }
        return varLenFieldNum;
    }

    private FieldSerializer.CachedField[] matchFieldsQuick(int length, ReadMetaInfo classFieldPair) {
        FieldSerializer.CachedField[] fields = new FieldSerializer.CachedField[length];
        FieldSerializer.CachedField[] allFields = this.getFields();
        for (int i = 0; i < length; ++i) {
            if (classFieldPair.fieldIndexMap[i] == -1) continue;
            fields[i] = allFields[classFieldPair.fieldIndexMap[i]];
        }
        return fields;
    }

    public CachedCompatibleFieldSerializerConfig getCompatibleFieldSerializerConfig() {
        return this.config;
    }

    private String getKey(Class type, String[] fields, byte[] fieldsCode) {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(fields);
        result = 31 * result + Arrays.hashCode(fieldsCode);
        return type.getName() + result;
    }

    private static class ReadFieldContext {
        ReadMetaInfo readMetaInfo;

        private ReadFieldContext() {
        }
    }

    private static class QuickSkipSerializer
    extends Serializer {
        private QuickSkipSerializer() {
        }

        public void write(Kryo kryo, Output output, Object o) {
            throw new KryoException("Should not reach here!");
        }

        public Object read(Kryo kryo, Input input, Class aClass) {
            kryo.reference(new Object());
            return null;
        }

        public void skip(Kryo kryo, Input input, int skipLen) {
            int before = input.position();
            kryo.readObjectOrNull(input, Object.class, (Serializer)this);
            int after = input.position();
            int skipCount = skipLen - (after - before);
            if (skipCount > 0) {
                input.skip(skipCount);
            }
        }
    }

    public static class CachedCompatibleFieldSerializerConfig
    extends FieldSerializer.FieldSerializerConfig {
        public CachedCompatibleFieldSerializerConfig clone() {
            return (CachedCompatibleFieldSerializerConfig)super.clone();
        }
    }
}

