/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.shade.io.netty.handler.codec.protobuf;

import com.alibaba.rocketmq.shade.io.netty.buffer.ByteBuf;
import com.alibaba.rocketmq.shade.io.netty.buffer.ByteBufOutputStream;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelHandler;
import com.alibaba.rocketmq.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.rocketmq.shade.io.netty.handler.codec.MessageToByteEncoder;
import com.google.protobuf.CodedOutputStream;
import java.io.OutputStream;

@ChannelHandler.Sharable
public class ProtobufVarint32LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int bodyLen = msg.readableBytes();
        int headerLen = CodedOutputStream.computeRawVarint32Size((int)bodyLen);
        out.ensureWritable(headerLen + bodyLen);
        CodedOutputStream headerOut = CodedOutputStream.newInstance((OutputStream)new ByteBufOutputStream(out), (int)headerLen);
        headerOut.writeRawVarint32(bodyLen);
        headerOut.flush();
        out.writeBytes(msg, msg.readerIndex(), bodyLen);
    }
}

