/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.stats;

import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.stats.MomentStatsItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class MomentStatsItemSet {
    private final ConcurrentHashMap<String, MomentStatsItem> statsItemTable = new ConcurrentHashMap(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Logger log;

    public MomentStatsItemSet(String statsName, ScheduledExecutorService scheduledExecutorService, Logger log) {
        this.statsName = statsName;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = log;
        this.init();
    }

    public ConcurrentHashMap<String, MomentStatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    MomentStatsItemSet.this.printAtMinutes();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        for (Map.Entry<String, MomentStatsItem> next : this.statsItemTable.entrySet()) {
            next.getValue().printAtMinutes();
        }
    }

    public void setValue(String statsKey, int value) {
        MomentStatsItem statsItem = this.getAndCreateStatsItem(statsKey);
        statsItem.getValue().set(value);
    }

    public MomentStatsItem getAndCreateStatsItem(String statsKey) {
        MomentStatsItem prev;
        MomentStatsItem statsItem = this.statsItemTable.get(statsKey);
        if (null != statsItem || null == (prev = this.statsItemTable.put(statsKey, statsItem = new MomentStatsItem(this.statsName, statsKey, this.scheduledExecutorService, this.log)))) {
            // empty if block
        }
        return statsItem;
    }
}

