/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl.consumer;

import com.alibaba.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.alibaba.rocketmq.client.exception.MQClientException;
import com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.alibaba.rocketmq.client.impl.consumer.PullRequest;
import com.alibaba.rocketmq.client.impl.consumer.RebalanceImpl;
import com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.alibaba.rocketmq.common.UtilAll;
import com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.alibaba.rocketmq.common.message.MessageQueue;
import com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RebalancePushImpl
extends RebalanceImpl {
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;

    public RebalancePushImpl(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        this(null, null, null, null, defaultMQPushConsumerImpl);
    }

    public RebalancePushImpl(String consumerGroup, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientFactory, DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        super(consumerGroup, messageModel, allocateMessageQueueStrategy, mQClientFactory);
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
    }

    @Override
    public void dispatchPullRequest(List<PullRequest> pullRequestList) {
        for (PullRequest pullRequest : pullRequestList) {
            this.defaultMQPushConsumerImpl.executePullRequestImmediately(pullRequest);
            log.info("doRebalance, {}, add a new pull request {}", (Object)this.consumerGroup, (Object)pullRequest);
        }
    }

    @Override
    public long computePullFromWhere(MessageQueue mq) {
        long result = -1L;
        ConsumeFromWhere consumeFromWhere = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeFromWhere();
        OffsetStore offsetStore = this.defaultMQPushConsumerImpl.getOffsetStore();
        switch (consumeFromWhere) {
            case CONSUME_FROM_LAST_OFFSET_AND_FROM_MIN_WHEN_BOOT_FIRST: 
            case CONSUME_FROM_MIN_OFFSET: 
            case CONSUME_FROM_MAX_OFFSET: 
            case CONSUME_FROM_LAST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        result = 0L;
                        break;
                    }
                    try {
                        result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                    }
                    catch (MQClientException e) {
                        result = -1L;
                    }
                    break;
                }
                result = -1L;
                break;
            }
            case CONSUME_FROM_FIRST_OFFSET: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    result = 0L;
                    break;
                }
                result = -1L;
                break;
            }
            case CONSUME_FROM_TIMESTAMP: {
                long lastOffset = offsetStore.readOffset(mq, ReadOffsetType.READ_FROM_STORE);
                if (lastOffset >= 0L) {
                    result = lastOffset;
                    break;
                }
                if (-1L == lastOffset) {
                    if (mq.getTopic().startsWith("%RETRY%")) {
                        try {
                            result = this.mQClientFactory.getMQAdminImpl().maxOffset(mq);
                        }
                        catch (MQClientException e) {
                            result = -1L;
                        }
                        break;
                    }
                    try {
                        long timestamp = UtilAll.parseDate((String)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeTimestamp(), (String)"yyyyMMddHHmmss").getTime();
                        result = this.mQClientFactory.getMQAdminImpl().searchOffset(mq, timestamp);
                    }
                    catch (MQClientException e) {
                        result = -1L;
                    }
                    break;
                }
                result = -1L;
                break;
            }
        }
        return result;
    }

    @Override
    public void messageQueueChanged(String topic, Set<MessageQueue> mqAll, Set<MessageQueue> mqDivided) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeUnnecessaryMessageQueue(MessageQueue mq, ProcessQueue pq) {
        this.defaultMQPushConsumerImpl.getOffsetStore().persist(mq);
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(mq);
        if (!this.defaultMQPushConsumerImpl.isConsumeOrderly()) return true;
        if (!MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) return true;
        try {
            if (!pq.getLockConsume().tryLock(1000L, TimeUnit.MILLISECONDS)) {
                log.warn("mq is consuming, so can not unlock it, {}", (Object)mq);
                return false;
            }
            try {
                this.unlock(mq, true);
                boolean bl = true;
                return bl;
            }
            finally {
                pq.getLockConsume().unlock();
            }
        }
        catch (Exception e) {
            log.error("removeUnnecessaryMessageQueue Exception", (Throwable)e);
        }
        return false;
    }
}

