/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl.consumer;

import com.alibaba.rocketmq.client.impl.factory.MQClientFactory;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.ServiceThread;
import org.slf4j.Logger;

public class RebalanceService
extends ServiceThread {
    private final Logger log = ClientLogger.getLog();
    private final MQClientFactory mqClientFactory;
    private static long WaitInterval = 10000L;

    public RebalanceService(MQClientFactory mqClientFactory) {
        this.mqClientFactory = mqClientFactory;
    }

    public void run() {
        this.log.info(this.getServiceName() + " service started");
        while (!this.isStoped()) {
            this.waitForRunning(WaitInterval);
            this.mqClientFactory.doRebalance();
        }
        this.log.info(this.getServiceName() + " service end");
    }

    public String getServiceName() {
        return RebalanceService.class.getSimpleName();
    }
}

