/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl.consumer;

import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.message.MessageExt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public class ProcessQueue {
    public static final long RebalanceLockMaxLiveTime = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockMaxLiveTime", "30000"));
    public static final long RebalanceLockInterval = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockInterval", "20000"));
    private final Logger log = ClientLogger.getLog();
    private final ReadWriteLock lockTreeMap = new ReentrantReadWriteLock();
    private final TreeMap<Long, MessageExt> msgTreeMap = new TreeMap();
    private volatile long queueOffsetMax = 0L;
    private final AtomicLong msgCount = new AtomicLong();
    private volatile boolean droped = false;
    private volatile boolean locked = false;
    private volatile long lastLockTimestamp = System.currentTimeMillis();
    private volatile boolean consuming = false;
    private final TreeMap<Long, MessageExt> msgTreeMapTemp = new TreeMap();

    public boolean isLockExpired() {
        boolean result = System.currentTimeMillis() - this.lastLockTimestamp > RebalanceLockMaxLiveTime;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessage(List<MessageExt> msgs) {
        boolean dispathToConsume = false;
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                for (MessageExt msg : msgs) {
                    this.msgTreeMap.put(msg.getQueueOffset(), msg);
                    this.queueOffsetMax = msg.getQueueOffset();
                }
                this.msgCount.addAndGet(msgs.size());
                if (!this.msgTreeMap.isEmpty() && !this.consuming) {
                    dispathToConsume = true;
                    this.consuming = true;
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("putMessage exception", (Throwable)e);
        }
        return dispathToConsume;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxSpan() {
        try {
            this.lockTreeMap.readLock().lockInterruptibly();
            try {
                if (this.msgTreeMap.isEmpty()) return 0L;
                long l = this.msgTreeMap.lastKey() - this.msgTreeMap.firstKey();
                return l;
            }
            finally {
                this.lockTreeMap.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("getMaxSpan exception", (Throwable)e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long removeMessage(List<MessageExt> msgs) {
        long result = -1L;
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    result = this.queueOffsetMax + 1L;
                    for (MessageExt msg : msgs) {
                        this.msgTreeMap.remove(msg.getQueueOffset());
                    }
                    this.msgCount.addAndGet(msgs.size() * -1);
                    if (!this.msgTreeMap.isEmpty()) {
                        result = this.msgTreeMap.firstKey();
                    }
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("removeMessage exception", (Throwable)e);
        }
        return result;
    }

    public TreeMap<Long, MessageExt> getMsgTreeMap() {
        return this.msgTreeMap;
    }

    public AtomicLong getMsgCount() {
        return this.msgCount;
    }

    public boolean isDroped() {
        return this.droped;
    }

    public void setDroped(boolean droped) {
        this.droped = droped;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.putAll(this.msgTreeMapTemp);
                this.msgTreeMapTemp.clear();
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("rollback exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                Long offset = this.msgTreeMapTemp.lastKey();
                this.msgCount.addAndGet(this.msgTreeMapTemp.size() * -1);
                this.msgTreeMapTemp.clear();
                if (offset == null) return -1L;
                long l = offset + 1L;
                return l;
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("commit exception", (Throwable)e);
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeMessageToCosumeAgain(List<MessageExt> msgs) {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                for (MessageExt msg : msgs) {
                    this.msgTreeMapTemp.remove(msg.getQueueOffset());
                    this.msgTreeMap.put(msg.getQueueOffset(), msg);
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("makeMessageToCosumeAgain exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageExt> takeMessags(int batchSize) {
        ArrayList<MessageExt> result = new ArrayList<MessageExt>(batchSize);
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    Map.Entry<Long, MessageExt> entry;
                    for (int i = 0; i < batchSize && (entry = this.msgTreeMap.pollFirstEntry()) != null; ++i) {
                        result.add(entry.getValue());
                        this.msgTreeMapTemp.put(entry.getKey(), entry.getValue());
                    }
                }
                if (result.isEmpty()) {
                    this.consuming = false;
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            this.log.error("takeMessags exception", (Throwable)e);
        }
        return result;
    }

    public long getLastLockTimestamp() {
        return this.lastLockTimestamp;
    }

    public void setLastLockTimestamp(long lastLockTimestamp) {
        this.lastLockTimestamp = lastLockTimestamp;
    }
}

