/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl;

import com.alibaba.rocketmq.client.impl.factory.MQClientFactory;
import com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.alibaba.rocketmq.client.log.ClientLogger;
import com.alibaba.rocketmq.common.message.MessageDecoder;
import com.alibaba.rocketmq.common.message.MessageExt;
import com.alibaba.rocketmq.common.protocol.MQProtos;
import com.alibaba.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import com.alibaba.rocketmq.common.protocol.header.NotifyConsumerIdsChangedRequestHeader;
import com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.ByteBuffer;
import org.slf4j.Logger;

public class ClientRemotingProcessor
implements NettyRequestProcessor {
    private final Logger log = ClientLogger.getLog();
    private final MQClientFactory mqClientFactory;

    public ClientRemotingProcessor(MQClientFactory mqClientFactory) {
        this.mqClientFactory = mqClientFactory;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        MQProtos.MQRequestCode code = MQProtos.MQRequestCode.valueOf((int)request.getCode());
        switch (code) {
            case CHECK_TRANSACTION_STATE: {
                return this.checkTransactionState(ctx, request);
            }
            case NOTIFY_CONSUMER_IDS_CHANGED: {
                return this.notifyConsumerIdsChanged(ctx, request);
            }
        }
        return null;
    }

    public RemotingCommand checkTransactionState(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        CheckTransactionStateRequestHeader requestHeader = (CheckTransactionStateRequestHeader)request.decodeCommandCustomHeader(CheckTransactionStateRequestHeader.class);
        ByteBuffer byteBuffer = ByteBuffer.wrap(request.getBody());
        MessageExt messageExt = MessageDecoder.decode((ByteBuffer)byteBuffer);
        if (messageExt != null) {
            String group = messageExt.getProperty("PGROUP");
            if (group != null) {
                MQProducerInner producer = this.mqClientFactory.selectProducer(group);
                if (producer != null) {
                    String addr = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
                    producer.checkTransactionState(addr, messageExt, requestHeader);
                } else {
                    this.log.debug("checkTransactionState, pick producer by group[{}] failed", (Object)group);
                }
            } else {
                this.log.warn("checkTransactionState, pick producer group failed");
            }
        } else {
            this.log.warn("checkTransactionState, decode message failed");
        }
        return null;
    }

    public RemotingCommand notifyConsumerIdsChanged(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        NotifyConsumerIdsChangedRequestHeader requestHeader = (NotifyConsumerIdsChangedRequestHeader)request.decodeCommandCustomHeader(NotifyConsumerIdsChangedRequestHeader.class);
        this.log.info("receive broker's notification[{}], the consumer group: {} changed, rebalance immediately", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()), (Object)requestHeader.getConsumerGroup());
        this.mqClientFactory.rebalanceImmediately();
        return null;
    }
}

