/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client;

import com.alibaba.rocketmq.remoting.common.RemotingUtil;

public class ClientConfig {
    private String namesrvAddr = System.getProperty("rocketmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String clientIP = RemotingUtil.getLocalAddress();
    private String instanceName = System.getProperty("rocketmq.client.name", "DEFAULT");
    private int clientCallbackExecutorThreads = Runtime.getRuntime().availableProcessors();
    private int pollNameServerInteval = 30000;
    private int heartbeatBrokerInterval = 30000;
    private int persistConsumerOffsetInterval = 5000;

    public String buildMQClientId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClientIP());
        sb.append("@");
        sb.append(this.getInstanceName());
        return sb.toString();
    }

    public void resetClientConfig(ClientConfig cc) {
        this.namesrvAddr = cc.namesrvAddr;
        this.clientIP = cc.clientIP;
        this.instanceName = cc.instanceName;
        this.clientCallbackExecutorThreads = cc.clientCallbackExecutorThreads;
        this.pollNameServerInteval = cc.pollNameServerInteval;
        this.heartbeatBrokerInterval = cc.heartbeatBrokerInterval;
        this.persistConsumerOffsetInterval = cc.persistConsumerOffsetInterval;
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig cc = new ClientConfig();
        cc.namesrvAddr = this.namesrvAddr;
        cc.clientIP = this.clientIP;
        cc.instanceName = this.instanceName;
        cc.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        cc.pollNameServerInteval = this.pollNameServerInteval;
        cc.heartbeatBrokerInterval = this.heartbeatBrokerInterval;
        cc.persistConsumerOffsetInterval = this.persistConsumerOffsetInterval;
        return cc;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public int getPollNameServerInteval() {
        return this.pollNameServerInteval;
    }

    public void setPollNameServerInteval(int pollNameServerInteval) {
        this.pollNameServerInteval = pollNameServerInteval;
    }

    public int getHeartbeatBrokerInterval() {
        return this.heartbeatBrokerInterval;
    }

    public void setHeartbeatBrokerInterval(int heartbeatBrokerInterval) {
        this.heartbeatBrokerInterval = heartbeatBrokerInterval;
    }

    public int getPersistConsumerOffsetInterval() {
        return this.persistConsumerOffsetInterval;
    }

    public void setPersistConsumerOffsetInterval(int persistConsumerOffsetInterval) {
        this.persistConsumerOffsetInterval = persistConsumerOffsetInterval;
    }

    public String toString() {
        return "ClientConfig [namesrvAddr=" + this.namesrvAddr + ", clientIP=" + this.clientIP + ", instanceName=" + this.instanceName + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", pollNameServerInteval=" + this.pollNameServerInteval + ", heartbeatBrokerInterval=" + this.heartbeatBrokerInterval + ", persistConsumerOffsetInterval=" + this.persistConsumerOffsetInterval + "]";
    }
}

