/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.client.impl;

import com.alibaba.rocketmq.client.ClientConfig;
import com.alibaba.rocketmq.client.impl.factory.MQClientFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MQClientManager {
    private static MQClientManager instance = new MQClientManager();
    private AtomicInteger factoryIndexGenerator = new AtomicInteger();
    private ConcurrentHashMap<String, MQClientFactory> factoryTable = new ConcurrentHashMap();

    private MQClientManager() {
    }

    public static MQClientManager getInstance() {
        return instance;
    }

    public MQClientFactory getAndCreateMQClientFactory(ClientConfig clientConfig) {
        MQClientFactory prev;
        String clientId = clientConfig.buildMQClientId();
        MQClientFactory factory = this.factoryTable.get(clientId);
        if (null == factory && (prev = this.factoryTable.putIfAbsent(clientId, factory = new MQClientFactory(clientConfig.cloneClientConfig(), this.factoryIndexGenerator.getAndIncrement(), clientId))) != null) {
            factory = prev;
        }
        return factory;
    }

    public void removeClientFactory(String clientId) {
        this.factoryTable.remove(clientId);
    }
}

